/***************************************************************************
                          knewfiledlg.cpp
                             -------------------
    copyright            : (C) 2000 by Michael Edwardes
    email                : mte@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kdecompat.h"

// ----------------------------------------------------------------------------
// QT Includes

#include <tqpixmap.h>
#include <tqlineedit.h>
#include <tqlabel.h>

// ----------------------------------------------------------------------------
// KDE Headers

#include <tdeglobal.h>
#include <tdelocale.h>
#include <kstandarddirs.h>
#include <kstdguiitem.h>
#include <kpushbutton.h>
#include <tdemessagebox.h>

#if KDE_IS_VERSION(3,1,90)
#include <tdeabc/addressee.h>
#include <tdeabc/stdaddressbook.h>
#endif

// ----------------------------------------------------------------------------
// Project Includes

#include "knewfiledlg.h"

KNewFileDlg::KNewFileDlg(TQWidget *parent, const char *name, const TQString& title)
  : KNewFileDlgDecl(parent,name,true)
{
  init(title);
}

KNewFileDlg::KNewFileDlg(TQString userName, TQString userStreet,
  TQString userTown, TQString userCounty, TQString userPostcode, TQString userTelephone,
  TQString userEmail, TQWidget *parent, const char *name, const TQString& title)
  : KNewFileDlgDecl(parent,name,true)
{
  userNameEdit->setText(userName);
  streetEdit->setText(userStreet);
  townEdit->setText(userTown);
  countyEdit->setText(userCounty);
  postcodeEdit->setText(userPostcode);
  telephoneEdit->setText(userTelephone);
  emailEdit->setText(userEmail);

  init(title);
}

void KNewFileDlg::init(const TQString& title)
{
  bool showLoadButton = false;
  okBtn->setGuiItem(KStdGuiItem::ok());
  cancelBtn->setGuiItem(KStdGuiItem::cancel());

  if (!title.isEmpty())
    setCaption(title);

#if KDE_IS_VERSION( 3, 1, 90 )
  TDEABC::StdAddressBook *ab = static_cast<TDEABC::StdAddressBook*>
    ( TDEABC::StdAddressBook::self() );
  if ( ab && !ab->whoAmI().isEmpty() )
      showLoadButton = true;
#endif

  if(!showLoadButton)
    tdeabcBtn->hide();

  userNameEdit->setFocus();

  connect(cancelBtn, TQT_SIGNAL(clicked()), this, TQT_SLOT(reject()));
  connect(okBtn, TQT_SIGNAL(clicked()), this, TQT_SLOT(okClicked()));
  connect(tdeabcBtn, TQT_SIGNAL(clicked()), this, TQT_SLOT(loadFromKABC()));
}

KNewFileDlg::~KNewFileDlg(){
}

void KNewFileDlg::okClicked()
{
  userNameText = userNameEdit->text();
  userStreetText = streetEdit->text();
  userTownText = townEdit->text();
  userCountyText = countyEdit->text();
  userPostcodeText = postcodeEdit->text();
  userTelephoneText = telephoneEdit->text();
  userEmailText = emailEdit->text();

  accept();
}

void KNewFileDlg::loadFromKABC(void)
{
#if KDE_IS_VERSION( 3, 1, 90 )
  TDEABC::StdAddressBook *ab = static_cast<TDEABC::StdAddressBook*>
    ( TDEABC::StdAddressBook::self() );
  if ( !ab )
    return;

  TDEABC::Addressee addr = ab->whoAmI();
  if ( addr.isEmpty() ) {
    KMessageBox::sorry(this, i18n("Unable to load data, because no contact has been associated with the owner of the standard addressbook."), i18n("Addressbook import"));
    return;
  }

  userNameEdit->setText( addr.formattedName() );
  emailEdit->setText( addr.preferredEmail() );

  TDEABC::PhoneNumber phone = addr.phoneNumber( TDEABC::PhoneNumber::Home );
  telephoneEdit->setText( phone.number() );

  TDEABC::Address a = addr.address( TDEABC::Address::Home );
  countyEdit->setText( a.country() + " / " + a.region() );
  postcodeEdit->setText( a.postalCode() );
  townEdit->setText( a.locality() );
  streetEdit->setText( a.street() );
#endif
}

#include "knewfiledlg.moc"
