/*
 * Copyright (C) 2004 Robert Hogan <robert at roberthogan dot net>
 */

#ifndef _ACTIVITYVIEWER_H_
#define _ACTIVITYVIEWER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tdeapplication.h>
#include <tdemainwindow.h>
#include <tdelistview.h>


class TDEToggleAction;
class KURL;
class TQLineEdit;
class TQComboBox;
class TQCheckBox;
class TDEListView;
class TQPushButton;
class TQLabel;
class TDEProcess;
class TDEConfig;
class KURLRequester;
class TDEListViewItem;
class TDEListViewSearchLine;


/**
 * This class serves as the main window for Activityviewer.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author $AUTHOR <$EMAIL>
 * @version $APP_VERSION
 */
class Activityviewer :  public TQWidget
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Activityviewer(TQWidget *parent, const char *name=0);

    /**
     * Default Destructor
     */
    virtual ~Activityviewer();

    /**
     * Use this method to load whatever file/URL you have
     */
    void load();
    void  setDirName(TQString);
    void createQuarDir();
    TQString getFileName(TQString);
    TQString getVirusName(TQString);
    TQString getWhen(TQString);
    TQString getSelectedVirusName();
    void insertItem(const  TQString &date, const  TQString &type, const TQString &event, const TQString &file);
    TDEListViewSearchLine* kLineEdit1;

protected:
    /**
     * Overridden virtuals for TQt drag 'n drop (XDND)
     */
    /*virtual void dragEnterEvent(TQDragEnterEvent *event);
    virtual void dropEvent(TQDropEvent *event);*/

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    //void saveProperties(TDEConfig *);

    /**
     * This function is called when this app is restored.  The TDEConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    //void readProperties(TDEConfig *);


private slots:
    void allActivity();
    void allActivityOfType(const TQString &type);
    void allActivityOfDate(const TQString &days);

private:
    void setupAccel();
    void setupActions();
    void populateActivity();

private:
    //ActivityviewerView *m_view;

  /*  KPrinter   *m_printer;
    TDEToggleAction *m_toolbarAction;
    TDEToggleAction *m_statusbarAction;*/


signals:
    void itemSelected(TQString abs_filename, int line);

public slots:

private slots:

    void slotOptions();
    //void patternTextChanged( const TQString &);
private:

    TQLineEdit *template_edit;
    TQComboBox *check_combo, *days_combo;
    KURLRequester *dir_combo;
    TQCheckBox *recursive_box;
    TDEListView *currentbox;
    TQPushButton *search_button, *cancel_button, *refresh_button, *search_button3, *cancel_button3;
    TQLabel *status_label, *matches_label;
    TDEProcess *childproc;
    TQString buf;
    TDEConfig* config;
    TQStringList lastQuarItems;
    TQStringList lastHistoryItems;
    TQStringList lastQuarLocations;
    TQStringList lastSearchPaths;
    TQString quarloc;
    TQPopupMenu* qmenu;
    TQPopupMenu* hmenu;
    TQStringList activity;
};

    
    class EventListItem : public TDEListViewItem
    {
        public:
            EventListItem( TDEListView *parent, TQString label1, TQString label2 = TQString::null, TQString label3 = TQString::null, TQString label4 = TQString::null);
            ~EventListItem();

            void paintCell ( TQPainter * p, const TQColorGroup & cg, int column, int width, int align );
 
    };


#endif // _Activityviewer_H_
