/***************************************************************************
 *   Copyright (C) 2007 by Ken Werner                                      *
 *   ken.werner@web.de                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include "threadedtrigger.h"
#include <tqapplication.h> 

//#include "kdebug.h"

ThreadedTrigger::ThreadedTrigger(TriggeredSource* inSource, unsigned long inRefreshSleep):
        mSource(inSource),
		mRefreshSleep(inRefreshSleep),
        mRunning(false)
		{
	connect(mSource, TQT_SIGNAL(enabledChanged(bool, Source*)), this, TQT_SLOT(enable(bool)));
}

ThreadedTrigger::~ThreadedTrigger(){
	enable(false);
}

void ThreadedTrigger::enable(bool inEnable){
	if(inEnable && !mRunning){ // start this thread (calls run())
		//kdDebug() << "start thread " << mSource->getName() << endl;
		// start the thread
        mRunning = true;
		this->start(TQThread::LowPriority);
	}else if(!inEnable && mRunning){ // stops the thread
		//kdDebug() << "stop thread " << mSource->getName() << endl;
        mRunning = false;
		mWaitMutex.lock();
        mWaitCond.wakeOne();
        mWaitMutex.unlock();
		this->wait();
	}
}

void ThreadedTrigger::run(){
    mWaitMutex.lock();
	while( mRunning ) {
		TQString text = mSource->fetchValue();
		UpdateEvent* ue = new UpdateEvent(text); // TQt will delete the ue when done
		TQApplication::postEvent(mSource, ue); // send the event to the TriggeredSource
        if(mWaitCond.wait(&mWaitMutex, mRefreshSleep))
            break; // we were woken up
	}
    // if we are here, the mutex must be locked:
    // 1. TQWaitCondition::wait locks it when it returns
    // 2. mWaitMutex is locked when we enter the loop
    mWaitMutex.unlock(); // unlock it again
}
#include "threadedtrigger.moc"
