/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2005 by the KFTPGrabber developers
 * Copyright (C) 2003-2005 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#ifndef KFTPWIDGETSFAILEDTRANSFERS_H
#define KFTPWIDGETSFAILEDTRANSFERS_H

#include <tdelistview.h>
#include <tdeaction.h>

#include <ntqwidget.h>
#include <ntqguardedptr.h>

#include "listviewitem.h"

namespace KFTPQueue {
  class FailedTransfer;
}

namespace KFTPWidgets {

class ListView;

/**
 * This class represents a TQListViewItem item that contains information
 * about a specific failed transfer.
 *
 * @author Jernej Kos
 */
class FailedTransferItem : public KFTPWidgets::ListViewItem
{
public:
    FailedTransferItem(KFTPQueue::FailedTransfer *transfer, TQListView *parent);
    
    KFTPQueue::FailedTransfer *getFailedTransfer() { return m_failedTransfer; }
private:
    TQGuardedPtr<KFTPQueue::FailedTransfer> m_failedTransfer;
};

/**
 * This class provides a list of failed transfers. The transfers
 * can be restarted.
 *
 * @author Jernej Kos
 */
class FailedTransfers : public TQWidget
{
Q_OBJECT
public:
    FailedTransfers(TQWidget *parent = 0, const char *name = 0);
    ~FailedTransfers();
    
    void updateActions();
    void initActions();
private:
    TDEActionCollection *actionCollection();
    
    KFTPWidgets::ListView *m_list;
    
    TDEAction *m_restartAction;
    TDEAction *m_addToQueueAction;
    TDEAction *m_addAllToQueueAction;
    TDEAction *m_removeAction;
    TDEAction *m_removeAllAction;
private slots:
    void slotRestart();
    void slotAddToQueue();
    void slotAddAllToQueue();
    void slotRemove();
    void slotRemoveAll();
    
    void contextMenuRequested(TDEListView*, TQListViewItem*, const TQPoint&);
    
    void slotFailedTransferNew(KFTPQueue::FailedTransfer*);
    void slotFailedTransferRemoved(long);
};

}

#endif
