/* This file is part of the Keep project
   Copyright (C) 2005 Jean-Rémy Falleri <jr.falleri@laposte.net>

   Keep is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   Keep is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Keep; if not, write to the
   Free Software Foundation, Inc.,
   51 Franklin Steet, Fifth Floor, Boston, MA 02110-1301, USA.           */

#ifndef _FORCEBACKUPDIALOG_H_
#define _FORCEBACKUPDIALOG_H_

#include <kdialogbase.h>

#include "forcebackupdialogview.h"
#include "rdbmanager.h"
#include "backup.h"

class ForceBackupDialog: public KDialogBase
{

	Q_OBJECT
  

public:
	ForceBackupDialog(TQWidget *parent);
	~ForceBackupDialog();

public slots:
	void slotForceBackup();
	void slotBackupError(Backup backup,TQString errorMessage);

private:
	void loadBackupList();
	ForceBackupDialogView * m_view;
	RDBManager *m_manager;

};

#endif
