/*
 * paranoia.h
 *
 * Copyright (C) 2002-2006 Christophe Thommeret <hftom@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 */

#ifndef PARANOIA_H
#define PARANOIA_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tqstringlist.h>
#include <tqthread.h>
#include <tqwidget.h>

#include <tdeconfig.h>

#include "kaffeineaudioencoder.h"
#include "paranoiasettings.h"

extern "C"
{
#ifdef HAVE_LIBCDIO_090
#include <cdio/paranoia/cdda.h>
#include <cdio/paranoia/paranoia.h>
#else // HAVE_LIBCDIO_090
#include <cdio/cdda.h>
#include <cdio/paranoia.h>
#endif // HAVE_LIBCDIO_090
}

class KiloConfig : public ParanoiaSettings
{
	Q_OBJECT
  

public:

	KiloConfig( TQWidget *parent, TDEConfig *confile, const TQStringList &encoders );
	~KiloConfig();

	TQString getEncoder();
	bool getNormalize();
	TQString getBaseDir();
	int getParanoiaMode();

public slots:

	virtual void accept();
	void setBaseDir();

private:

	TDEConfig *Conf;
};

class Paranoia : public TQThread
{
public:
	Paranoia();
	bool init( TQString dev );
	~Paranoia();
	bool encode( const TQStringList&, TQWidget* );
	long getTracks();
	TQString trackTime( int t );
	int trackFirstSector( int t );
	int discFirstSector();
	int discLastSector();
	virtual void run();
	bool running() {return isRunning;}
	int getProgress() {return progress;}

private:

	bool findCdrom();
	bool procCdrom( TQString name );
	bool initTrack( int t );
	void setMode( int mode );
	bool isAudio( int t );
	TQString trackSize( int t );
	long trackSectorSize( int t );
	bool loadEncoder( TQWidget* );
	void unloadEncoder();
	bool validPath( TQString path );
	bool setPath( TQString &path, const TQString &artist, const TQString &album );

	long nTracks;
	cdrom_drive_t *d;
	cdrom_paranoia_t *p;
	long currentSector, endOfTrack;
	bool isRunning;
	TQStringList encodingList;
	TQWidget *myParent;
	KaffeineAudioEncoder *currentEncoder;
	TQString encoderDesktop;
	bool normalize;
	TQString baseDir;
	int paraMode;
	int progress;
};

#endif /* PARANOIA_H */
