// KDE includes

#include <tdecmdlineargs.h>
#include <tdeaboutdata.h>
#include <kuniqueapplication.h>

#include "app.h"

static TDECmdLineOptions options[] =
{
    TDECmdLineLastOption
};

int main(int argc, char *argv[])
{

    TDELocale::setMainCatalogue("adept_installer");

    putenv( "TQT_IM_MODULE=xim" );
    TQString description = i18n("Adept Installer");

    TDEAboutData aboutData( "adept_installer",
                          I18N_NOOP("Adept Installer"),
                          "2.1 Cruiser",
                          description.latin1(),
                          TDEAboutData::License_BSD,
                          I18N_NOOP("(c) 2005, 2006 Peter Rockai"),
                          0,
                          "http://web.mornfall.net/adept.html");

    aboutData.addAuthor ( "Peter Rockai",
                          I18N_NOOP("developer"),
                          "me at mornfall dot net",
                          "http://web.mornfall.net");

    TDECmdLineArgs::init( argc, argv, &aboutData );
    TDECmdLineArgs::addCmdLineOptions( options );

    TDEApplication app;

    TDECmdLineArgs* args = TDECmdLineArgs::parsedArgs();

    TDEGlobal::locale()->insertCatalogue(TQString::fromUtf8("libept"));

    App *ta = new App();

    app.setMainWidget(ta);
    ta->show();

    return app.exec();
}
