/** -*- C++ -*-
	@file adept/installerview.h
	@author Peter Rockai <me@mornfall.net>
*/

#include <tqtimer.h>
#include <adept/installerviewui.h>
#include <adept/groupeddesktopselector.h>

#ifndef EPT_INSTALLERVIEW_H
#define EPT_INSTALLERVIEW_H

namespace adept {
class InstallerView : public InstallerViewUi
{
    Q_OBJECT
  
public:
    typedef predicate::Predicate< entity::Desktop > Predicate;
    InstallerView( TQWidget *p = 0, const char *n = 0 );
    GroupedDesktopSelector *selector() { return m_selector; }
protected slots:
    void textChanged();
    void showDescription( cache::entity::Desktop );
public slots:
    void rebuild();
protected:
    bool m_inRebuild;
    TQTimer timer;
};

}

#endif
