#include "nex.h"
#include "noatunplugin.h"

#include <kprocess.h>
#include <tdemessagebox.h>
#include <tdelocale.h>
#include <kstandarddirs.h>

extern "C"
{
Plugin *create_plugin()
{
	TDEGlobal::locale()->insertCatalogue("nexscope");
	return new NexPlugin();
}
}


NexPlugin::NexPlugin()
{
	connect(&process, TQT_SIGNAL(processExited(TDEProcess *)), this, TQT_SLOT(processExited(TDEProcess *)));
}

NexPlugin::~NexPlugin()
{
	process.kill();
}

void NexPlugin::init()
{
	process << TDEStandardDirs::findExe("nexscope.bin");

	// Note that process.start() will fail if findExe fails, so there's no real need
	// for two separate checks.
	if(!process.start(TDEProcess::NotifyOnExit, (TDEProcess::Communication)(TDEProcess::Stdin | TDEProcess::Stdout)))
	{
		KMessageBox::error(0, i18n("Unable to start noatunNex. Check your installation."));
		unload();
	}

}

void NexPlugin::processExited(TDEProcess *)
{
	unload();
}

#include  "noatunplugin.moc"

