/*
** Copyright (C) 1999,2000 Toivo Pedaste <toivo@ucs.uwa.edu.au>
**
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
** MA 02110-1301, USA.
*/

/*
** Bug reports and questions can be sent to kde-devel@kde.org
*/


#ifndef FINDF_H
#define FINDF_H

#include "../config.h"

// Standard Headers
#include <stdio.h>

// TQt Headers
#include <tqdir.h>
#include <tqwidget.h>
#include <tqframe.h>
#include <tqlabel.h>
#include <tqfiledialog.h>
#include <tqgroupbox.h>
#include <tqcheckbox.h>
#include <tqlayout.h>

// KDE headers
#include <tdeapplication.h>
#include <tdemenubar.h>
#include <tdelistview.h>
#include <kdialogbase.h>

class FindF : public KDialogBase
{
  Q_OBJECT
  

public:

  FindF ( TQWidget *parent = 0);
  ~FindF();
  void resizeEvent(TQResizeEvent *);
  void dropEvent(TQDropEvent *);
  void dragEnterEvent(TQDragEnterEvent* e);
  void checkSearchAll();

  
private:
  void doFind(const TQString &str);
  // Do the actual search

  TQLineEdit *value;
  TQListView *tab;
  TQVBoxLayout* vl;
  TQVBoxLayout* vtop, vf;

  TQHBoxLayout* hb;
  TQCheckBox *searchAll;
  TQPixmap tick;

signals:
    void findf_signal();
    void findf_done_signal();

public slots:
  void done_slot();
  void ok_slot();
  void search(TQListViewItem *);
  void textChanged ( const TQString & text);

};

#endif
