#ifndef KJSLIDERS_H
#define KJSLIDERS_H

#include "kjwidget.h"
#include <tqpainter.h>

class KJLoader;
class KJPitchText;
class KJVolumeText;


class KJVolumeBMP : public KJWidget
{
public:
	KJVolumeBMP(const TQStringList &, KJLoader *parent);

	virtual void paint(TQPainter *, const TQRect &rect);
	virtual bool mousePress(const TQPoint &pos);
	virtual void mouseRelease(const TQPoint &pos, bool);
	virtual void timeUpdate(int);
	virtual void mouseMove(const TQPoint &pos, bool);

	virtual TQString tip();

	void setText(KJVolumeText *t) { mText=t; }

private:
	TQPixmap mImages;
	TQImage mPos;
	int mVolume, mOldVolume;
	int mWidth, mCount;
	KJVolumeText *mText;
};


class KJVolumeBar : public KJWidget
{
public:
	KJVolumeBar(const TQStringList &, KJLoader *parent);

	virtual void paint(TQPainter *, const TQRect &rect);
	virtual bool mousePress(const TQPoint &pos);
	virtual void mouseRelease(const TQPoint &pos, bool);
	virtual void timeUpdate(int);
	virtual void mouseMove(const TQPoint &pos, bool);

	virtual TQString tip();

	void setText(KJVolumeText *t) { mText=t; }

private:
	TQPixmap mSlider;
	TQPixmap mBack;
	int mVolume;
	KJVolumeText *mText;
};


class KJPitchBMP : public KJWidget
{
public:
	KJPitchBMP(const TQStringList &, KJLoader *parent);

	virtual void paint(TQPainter *, const TQRect &rect);
	virtual bool mousePress(const TQPoint &pos);
	virtual void mouseRelease(const TQPoint &pos, bool);
	virtual void timeUpdate(int);
	virtual void newFile();
	virtual void mouseMove(const TQPoint &pos, bool);
	virtual void readConfig();
	
	virtual TQString tip();

	void setText(KJPitchText *t) { mText=t; }

private:
	TQPixmap mImages;
	TQImage mPos;
	int mWidth, mCount;
	float mCurrentPitch;
	float mOldPitch;
	float mMinPitch;
	float mMaxPitch;

	KJPitchText *mText;
};

#endif
