#include "uichooser_part.h"

#include <tqvbox.h>

#include <kdialogbase.h>
#include <kdevgenericfactory.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <kdevcore.h>
#include <configwidgetproxy.h>
#include <kdevplugininfo.h>

#include "uichooser_widget.h"

#define UICHOOSERSETTINGSPAGE 1

typedef KDevGenericFactory<UIChooserPart> UIChooserFactory;
static const KDevPluginInfo data("kdevuichooser");
K_EXPORT_COMPONENT_FACTORY( libkdevuichooser, UIChooserFactory( data ) )

UIChooserPart::UIChooserPart(TQObject *parent, const char *name, const TQStringList &)
  : KDevPlugin( &data, parent, name ? name : "UIChooserPart")
{
	setInstance(UIChooserFactory::instance());

	_configProxy = new ConfigWidgetProxy( core() );
	_configProxy->createGlobalConfigPage( i18n("User Interface"), UICHOOSERSETTINGSPAGE, info()->icon() );
	connect( _configProxy, TQT_SIGNAL(insertConfigWidget(const KDialogBase*, TQWidget*, unsigned int )),
		this, TQT_SLOT(insertConfigWidget(const KDialogBase*, TQWidget*, unsigned int )) );
}


UIChooserPart::~UIChooserPart()
{
	delete _configProxy;
}

void UIChooserPart::insertConfigWidget( const KDialogBase * dlg, TQWidget * page, unsigned int pagenumber )
{
	kdDebug() << k_funcinfo << endl;

	if ( pagenumber == UICHOOSERSETTINGSPAGE )
	{
		UIChooserWidget * w = new UIChooserWidget( this, page, "UIChooser widget" );
		connect( dlg, TQT_SIGNAL(okClicked()), w, TQT_SLOT(accept()) );
	}
}




#include "uichooser_part.moc"
