/***************************************************************************
                          mediacontrol configuration dialog
                             -------------------
    begin                : forgot :/
    copyright            : (C) 2000-2005 by Stefan Gehn
    email                : metz {AT} gehn {DOT} net

    code-skeleton taken from knewsticker which is
    Copyright (c) Frerich Raabe <raabe@kde.org>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "mediacontrolconfig.h"
#include "mediacontrolconfigwidget.h"

#include <tqdir.h>
#include <tqcheckbox.h>
#include <tqlistbox.h>
#include <tqtoolbutton.h>
#include <tqlayout.h>
#include <tqgroupbox.h>

#include <tdeapplication.h>
#include <kdebug.h>
#include <tdeconfig.h>
#include <tdeglobal.h>
#include <kiconloader.h>
#include <tdelistbox.h>
#include <tdelocale.h>
#include <knuminput.h>
#include <kstandarddirs.h>

MediaControlConfig::MediaControlConfig( ConfigFrontend *cfg, TQWidget *parent, const char* name)
: KDialogBase( parent, name, false, i18n("MediaControl"), Ok | Apply | Cancel, Ok, false )
{
	_configFrontend = cfg;
	if (!_configFrontend) // emergency!!!
		return;

	_child = new MediaControlConfigWidget(this);
	setMainWidget ( _child );

#ifdef HAVE_XMMS
	_child->playerListBox->insertItem("XMMS");
#endif
	_child->playerListBox->insertItem("Noatun");
	_child->playerListBox->insertItem("Amarok");
	_child->playerListBox->insertItem("JuK");
	_child->playerListBox->insertItem("mpd");
	_child->playerListBox->insertItem("KsCD");

	_child->themeListBox->clear();
	// fill with available skins
	TDEGlobal::dirs()->addResourceType("themes", TDEStandardDirs::kde_default("data") + "mediacontrol");
	TQStringList list = TDEGlobal::dirs()->resourceDirs("themes");
	for (TQStringList::ConstIterator it = list.constBegin(); it != list.constEnd(); ++it)
		readSkinDir(*it);

	connect(_child->mWheelScrollAmount, TQT_SIGNAL(valueChanged(int)), TQT_SLOT(slotConfigChanged()));
	connect(_child->playerListBox, TQT_SIGNAL(selectionChanged()), TQT_SLOT(slotConfigChanged()));
	connect(_child->themeListBox, TQT_SIGNAL(selectionChanged()), TQT_SLOT(slotConfigChanged()));
	connect(_child->themeListBox, TQT_SIGNAL(selectionChanged(TQListBoxItem *)), TQT_SLOT(slotChangePreview(TQListBoxItem *)));
	connect(_child->mUseThemes, TQT_SIGNAL(toggled(bool)), TQT_SLOT(slotConfigChanged()) );
	connect(_child->mUseThemes, TQT_SIGNAL(toggled(bool)), TQT_SLOT(slotUseThemesToggled(bool)) );

	load();
	show();

	enableButtonApply ( false ); // apply id disabled until something changed
}

void MediaControlConfig::readSkinDir( const TQString &dir )
{
	TQDir directory( dir );
	if (!directory.exists())
		return;

	const TQFileInfoList *list = directory.entryInfoList();
	TQFileInfoListIterator it(*list);

	while ( it.current() )
	{
		// append directory-name to our theme-listbox
		if ( TQFile(it.current()->absFilePath()+"/play.png").exists() )
			_child->themeListBox->insertItem ( it.current()->baseName(), -1 );
		++it;
	}
}

// ============================================================================

void MediaControlConfig::load()
{
	// find the playerstring from config in the playerlist and select it if found
	TQListBoxItem *item = 0;

	item = _child->playerListBox->findItem(  _configFrontend->player() );
	if ( item )
		_child->playerListBox->setCurrentItem ( item );
	else
		_child->playerListBox->setCurrentItem( 0 );

	// reset item to a proper state
	item=0;

	_child->mWheelScrollAmount->setValue( _configFrontend->mouseWheelSpeed() );

	// Select the used Theme
	item = _child->themeListBox->findItem(  _configFrontend->theme() );
	if ( item )
		_child->themeListBox->setCurrentItem( item );
	else
		_child->themeListBox->setCurrentItem( 0 );


	bool ison = _configFrontend->useCustomTheme();
	_child->mUseThemes->setChecked( ison );
	slotUseThemesToggled( ison );
}

void MediaControlConfig::save()
{
//	kdDebug(90200) << "MediaControlConfig::save()" << endl;
	for ( int it=0 ; it <= _child->playerListBox->numRows(); ++it )
	{
		if ( _child->playerListBox->isSelected(it) )
		{
			_configFrontend->setPlayer ( _child->playerListBox->text(it) );
		}
	}

	_configFrontend->setMouseWheelSpeed ( _child->mWheelScrollAmount->value() );

	for ( int it=0 ; it <= _child->themeListBox->numRows(); ++it )
	{
		if ( _child->themeListBox->isSelected(it) )
		{
			_configFrontend->setTheme ( _child->themeListBox->text(it) );
		}
	}

	_configFrontend->setUseCustomTheme( _child->mUseThemes->isChecked() );

	emit configChanged();
}

void MediaControlConfig::slotApply()
{
	save();
	enableButtonApply(false);
}

void MediaControlConfig::slotOk()
{
	save();
	emit closing();
}

void MediaControlConfig::slotCancel()
{
	emit closing();
}

void MediaControlConfig::slotConfigChanged()
{
	enableButtonApply ( true );
}

void MediaControlConfig::slotChangePreview(TQListBoxItem *item)
{
	TQString skindir = item->text();
	_child->previewPrev->setIconSet(SmallIconSet(locate("themes",skindir+"/prev.png")));
	_child->previewPlay->setIconSet(SmallIconSet(locate("themes",skindir+"/play.png")));
	_child->previewPause->setIconSet(SmallIconSet(locate("themes",skindir+"/pause.png")));
	_child->previewStop->setIconSet(SmallIconSet(locate("themes",skindir+"/stop.png")));
	_child->previewNext->setIconSet(SmallIconSet(locate("themes",skindir+"/next.png")));
}

void MediaControlConfig::slotUseThemesToggled(bool on)
{
	_child->themeListBox->setEnabled(on);
	_child->previewGroupBox->setEnabled(on);
}

#include "mediacontrolconfig.moc"
