#################################################
#
#  (C) 2013 Alexander Golubev 
#  fatzer2 (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

##### check for gcc visibility support #########
# FIXME
# This should check for [T]Qt3 visibility support

if( WITH_GCC_VISIBILITY )
  if( NOT UNIX )
    tde_message_fatal( "gcc visibility support was requested, but your system is not *NIX" )
  endif( NOT UNIX )
  set( __KDE_HAVE_GCC_VISIBILITY 1 )
  set( CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fvisibility=hidden -fvisibility-inlines-hidden")
  set( CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fvisibility=hidden -fvisibility-inlines-hidden")
endif( WITH_GCC_VISIBILITY )


tde_setup_architecture_flags( )


##### kicker-applets ############################

if( BUILD_KICKER_APPLETS )
  check_include_file( "fcntl.h" HAVE_FCNTL_H )

  if( WITH_XMMS )
    # FIXME: xmms is realy outdated, so check if this is really works
    check_library_exists( xmms_remote_is_running xmms HAVE_XMMSLIB )
    check_symbol_exist( xmms_remote_is_running "xmms/xmmsctrl.h" HAVE_XMMS )
    if( HAVE_XMMS_LIB AND HAVE_XMMS )
      set( XMMS_LIBRARIES xmms )
    else( HAVE_XMMS )
      tde_message_fatal( "xmms is required, but was not found on your system" )
    endif( HAVE_XMMS )
  endif( WITH_XMMS )
endif( BUILD_KICKER_APPLETS )


##### konq-plugins ##############################

if( BUILD_KONQ_PLUGINS )
  check_include_file( "pty.h"       HAVE_PTY_H       )
  check_include_file( "terminos.h"  HAVE_TERMIOS_H   )
  check_include_file( "stropts.h"   HAVE_STROPTS     )
  check_include_file( "sys/ioctl.h" HAVE_SYS_IOCTL_H )
  check_include_file( "libutil.h"   HAVE_LIBUTIL_H   )
  check_include_file( "util.h"      HAVE_UTIL_H      )
endif( BUILD_KONQ_PLUGINS )


##### other dependencies ########################

if( BUILD_KONQ_PLUGINS OR BUILD_NOATUN_PLUGINS )
  # arts
  if( WITH_ARTS )
    pkg_search_module( ARTS arts )
    if( NOT ARTS_FOUND )
      tde_message_fatal( "aRts is requested, but was not found on your system" )
    endif( )
  endif( WITH_ARTS )
endif( BUILD_KONQ_PLUGINS OR BUILD_NOATUN_PLUGINS )


if( BUILD_NOATUN_PLUGINS )
  # sdl
  if( WITH_SDL )
    pkg_search_module( SDL sdl )
    if( NOT SDL_FOUND )
      tde_message_fatal( "SDL is requested, but was not found on your system" )
    endif( )
  endif( WITH_SDL )

  # berkeley db
  if( WITH_BERKELEY_DB )
    find_path( BERKELEY_DB_INCLUDE_DIRS db_cxx.h )
    find_library( BERKELEY_DB_LIBS db_cxx )
    if( BERKELEY_DB_INCLUDE_DIRS-NOTFOUND OR BERKELEY_DB_LIBS-NOTFOUND )
      tde_message_fatal( "BerkeleyDB is requested, but was not found on your system" )
    endif( )
  endif( WITH_BERKELEY_DB )
endif( BUILD_NOATUN_PLUGINS )


# required stuff
find_package( TQt )
find_package( TDE )
