/***************************************************************************
 *   Copyright (C) 1999-2001 by Bernd Gehrmann and the KDevelop Team       *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MakeActionFilter_h
#define MakeActionFilter_h

#include <tqobject.h>
#include <tqregexp.h>
#include <tqvaluelist.h>
#include "outputfilter.h"

class MakeItem;
class ActionItem;

class MakeActionFilter : public TQObject, public OutputFilter
{
Q_OBJECT
  

public:
#ifdef DEBUG
	static void test();
#endif

	MakeActionFilter( OutputFilter& );

	class ActionFormat
        {
           public:
                ActionFormat():m_toolGroup(-1) {}
		ActionFormat( const TQString&, const TQString&, const char * regExp, int file);
		ActionFormat( const TQString&, int tool, int file, const char * regExp);
                TQString tool();
                TQString file();
                const TQString& action() const     {return m_action;}
                bool matches(const TQString& line);
           private:
		TQString m_action;
		TQRegExp m_expression;
		TQString m_tool;
                int m_toolGroup;
                int m_fileGroup;
	};
	static ActionFormat* actionFormats();

	void processLine( const TQString& line );

signals:
	void item( MakeItem* );

private:
	static ActionItem* matchLine( const TQString& line );
};

#endif
