#################################################
#
#  (C) 2010-2011 Serghei Amelian
#  serghei (DOT) amelian (AT) gmail.com
#
#  Improvements and feedback are welcome
#
#  This file is released under GPL >= 2
#
#################################################

check_include_file( "sys/stropts.h" HAVE_SYS_STROPTS_H )
check_function_exists( "mkfifo" HAVE_MKFIFO )


##### check for gcc visibility support #########
# FIXME
# This should check for [T]Qt3 visibility support

if( WITH_GCC_VISIBILITY )
  if( NOT UNIX )
    tde_message_fatal(FATAL_ERROR "\ngcc visibility support was requested, but your system is not *NIX" )
  endif( NOT UNIX )
  set( __KDE_HAVE_GCC_VISIBILITY 1 )
  set( CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -fvisibility=hidden -fvisibility-inlines-hidden")
  set( CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} -fvisibility=hidden -fvisibility-inlines-hidden")
endif( )


# check for berkeley db
# we need at least bdb 4.1, but I do not check for version
# because this is really old and trinity will not
# working anyway on such old systems
check_c_source_compiles("
    #include <db.h>
    void main() { DB *db; db->open(db, 0, 0, NULL, DB_BTREE, DB_CREATE, 0644); } "
  HAVE_BERKELEY_DB )

if( HAVE_BERKELEY_DB )
  set( BDB_LIBRARY db )
else( )
  tde_message_fatal( "berkeley db are required, but not found on your system" )
endif( )


# check for subversion
if( WITH_VCS_SUBVERSION )
  pkg_search_module( APR apr-1 )
  if( NOT APR_FOUND )
    tde_message_fatal( "apr-1 are requested, but not found on your system" )
  endif( )

  tde_save( CMAKE_REQUIRED_INCLUDES )
  set( CMAKE_REQUIRED_INCLUDES ${APR_INCLUDE_DIRS} )
  check_include_file_cxx( "subversion-1/svn_types.h" HAVE_SUBVERSION_1_SVN_TYPES_H )
  tde_restore( CMAKE_REQUIRED_INCLUDES )

  check_library_exists( svn_client-1 svn_client_version "" HAVE_SVN_CLIENT_1 )

  if( NOT (HAVE_SUBVERSION_1_SVN_TYPES_H AND HAVE_SVN_CLIENT_1) )
    tde_message_fatal( "svn_client-1 are requested, but not found on your system" )
  endif( )

  set( SVN_LIBRARIES svn_client-1 svn_subr-1 svn_ra-1 )
endif( )


# required stuff
find_package( TQt )
find_package( TDE )
