#!/bin/sh

# Checks for Xscreensaver directory (may vary on different distributions)
if [ -d /usr/libexec/xscreensaver ]; then
  XSDIR=/usr/libexec/xscreensaver
elif [ -d /usr/lib64/xscreensaver ]; then
  XSDIR=/usr/lib64/xscreensaver
else
  XSDIR=/usr/lib/xscreensaver
fi

# Gets list of screensavers. Exclude 'config'.
scsvs=""
if [ -d "$XSDIR" ]; then
  LASTD=$PWD
  cd "${XSDIR}" >/dev/null
  for i in *; do
    if [ "${i}" != "config" ]; then
      scsvs="${scsvs} ${i}"
    fi
  done
  cd "$LASTD"
fi

echo $scsvs

# Removes useless .desktop files, if any
for f in ScreenSavers/*.desktop; do
  # Gets the command line for this screensaver
  Exec="$(sed -n '/^Exec=kxsconfig / s/.* \(.*\)/\1/' $f)"
  if [ ! -x "${XSDIR}/${Exec}" ]; then
    echo "Removing ${f}"
    rm -f "${f}"
  fi
done

# Creates missing screensavers .desktop files
for name in $scsvs; do
    if test -f "${XSDIR}/$name" && test -f "/usr/share/xscreensaver/config/$name.xml" && test ! -f "ScreenSavers/$name.desktop"; then
        echo "name: $name"
        label=`grep '<screensaver.*_label' /usr/share/xscreensaver/config/$name.xml | sed -e 's#^.*_label=\"\(.*\)\".*$#\1#'`
        echo "label: $label"
        f=ScreenSavers/$name.desktop
        sed -e "s#@NAME@#$name#; s#@LABEL@#$label#" ScreenSavers/xscreensaver.template > $f
        if ldd "${XSDIR}/$name" 2>&1 | grep libGL; then
            sed -e "s,@GL1@,X-TDE-Category=OpenGL Screen Savers,; s,@GL2@,X-TDE-Type=OpenGL," $f > $f.new
        else
            grep -v @GL $f > $f.new
        fi
        mv $f.new $f
    fi
done

