/*
    This file is part of libkcal.

    Copyright (c) 2003 Cornelius Schumacher <schumacher@kde.org>
    Copyright (C) 2005 Reinhold Kainhofer <reinhold@kainhofer.com>


    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "calendarlocal.h"
#include "vcalformat.h"
#include "filestorage.h"

extern "C" {
#include "icaltimezone.h"
}

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <tdecmdlineargs.h>

#include <tqfile.h>
#include <tqfileinfo.h>

using namespace KCal;

static const TDECmdLineOptions options[] =
{
  { "verbose", "Verbose output", 0 },
  { "+input", "Name of input file", 0 },
  { "+output", "Name of output file", 0 },
  TDECmdLineLastOption
};

int main( int argc, char **argv )
{
  TDEAboutData aboutData("testvcalexport", "Part of LibKCal's test suite. Checks if export to vCalendar still works correctly.", "0.1");
  TDECmdLineArgs::init( argc, argv, &aboutData );
  TDECmdLineArgs::addCmdLineOptions( options );

  TDEApplication app( false, false );

  TDECmdLineArgs *args = TDECmdLineArgs::parsedArgs();

  if ( args->count() != 2 ) {
    args->usage( "Wrong number of arguments." );
  }

  // use zoneinfo data from source dir
  set_zone_directory( KDETOPSRCDIR "/libkcal/libical/zoneinfo" );

  TQString input = TQFile::decodeName( args->arg( 0 ) );
  TQString output = TQFile::decodeName( args->arg( 1 ) );

  TQFileInfo outputFileInfo( output );
  output = outputFileInfo.absFilePath();

  kdDebug(5800) << "Input file: " << input << endl;
  kdDebug(5800) << "Output file: " << output << endl;


  CalendarLocal cal( TQString::fromLatin1("UTC") );

  if ( !cal.load( input ) ) return 1;
	TQString tz = cal.nonKDECustomProperty( "X-LibKCal-Testsuite-OutTZ" );
	if ( !tz.isEmpty() ) {
	  cal.setTimeZoneIdViewOnly( tz );
	}
  FileStorage storage( &cal, output, new VCalFormat );
  if ( !storage.save() ) return 1;

  return 0;
}

