/* This file is part of KWordQuiz
  Copyright (C) 2004 Peter Hedlund <peter.hedlund@kdemail.net>

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License version 2 as published by the Free Software Foundation.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
*/

#ifndef WTQPRINTDIALOGPAGE_H
#define WTQPRINTDIALOGPAGE_H


#include <kdeprint/kprintdialogpage.h>

/**
Print dialog page to provide specific print options for KWordQuiz

@author Peter Hedlund
*/
class WQPrintDialogPage : public KPrintDialogPage
{
Q_OBJECT
  TQ_OBJECT
public:
    WQPrintDialogPage( TQWidget *parent = 0, const char *name = 0 );

    ~WQPrintDialogPage();
   //reimplement virtual functions
   void getOptions(TQMap<TQString,TQString>& opts, bool incldef = false);
   void setOptions(const TQMap<TQString,TQString>& opts);
   bool isValid(const TQString& msg );

private:
  TQButtonGroup * g;
  TQRadioButton * rb0;
  TQRadioButton * rb1;
  TQRadioButton * rb2;
};

#endif
