/***************************************************************************

                   entry dialog for table cell contents

    -----------------------------------------------------------------------

    begin          : Thu Mar 11 20:50:53 MET 1999

    copyright      : (C) 1999-2001 Ewald Arnold <kvoctrain@ewald-arnold.de>
                     (C) 2001 The KDE-EDU team
                     (C) 2005 Peter Hedlund <peter.hedlund@kdemail.net>

    -----------------------------------------------------------------------

 ***************************************************************************

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "EntryDlg.h"

#include <tqlayout.h>
#include <tqlineedit.h>

#include <kmainwindow.h>
#include <kapplication.h>
#include <kwinmodule.h>

#include <langset.h>
#include <klocale.h>

EntryDlg::EntryDlg(
  KMainWindow   *main,
  kvoctrainDoc  *doc,
  bool           multi_sel,
  bool           origin,
  grade_t        f_grd,
  grade_t        t_grd,
  count_t        f_qcount,
  count_t        t_qcount,
  count_t        f_bcount,
  count_t        t_bcount,
  time_t         f_qdate,
  time_t         t_qdate,
  TQString        f_faux_ami,
  TQString        t_faux_ami,
  TQString        expr,
  int            lesson,
  TQComboBox     *lessonbox,
  TQString        lang,
  LangSet       &langset,
  TQString        rem,
  TQString        type,
  TQString        pronunce,
  TQString        synonym,
  TQString        antonym,
  TQString        example,
  TQString        usagelabel,
  TQString        paraphrase,
  const          Conjugation &con_prefix,
  const          Conjugation &conjugations,
  const          Article &/*article*/,
  const          Comparison &comp,
  const          MultipleChoice &mc,
  QueryManager  &querymanager,
  const TQString &title,
  bool           active,
  const TQFont&   ipafont,
  TQWidget       *parent,
  const char    *name,
  bool           modal)
  :
  KDialogBase(Tabbed, title, User1|User2|User3|Apply|Close, Apply, parent, name, modal, false,
    KGuiItem(i18n("&Reset")),
    KGuiItem(TQString(), "view_left_right"),
    KGuiItem(TQString(), "view_top_bottom"))

{
  mainwin = main;
  docked = false;
  edit_row = -1;
  edit_col = -1;
  from_page = 0;
  to_page = 0;

  TQString s;
  if (langset.findLongId(lang).isEmpty() )
    s = lang;
  else
    s = langset.findLongId(lang);

  TQFrame *page;
  TQVBoxLayout *topLayout;

  if (origin)
  {
    page = addPage( i18n("Co&mmon") );
    topLayout = new TQVBoxLayout( page, 0, KDialog::spacingHint() );
    comm_page = new CommonEntryPage (this, doc, multi_sel, expr, lesson, lessonbox,
                                      lang, type, pronunce, usagelabel,
                                      i18n("Original &expression in %1:").tqarg(s), querymanager, active,
                                      ipafont, page, name);
    topLayout->addWidget(comm_page);

    page = addPage( i18n("A&dditional") );
    topLayout = new TQVBoxLayout( page, 0, KDialog::spacingHint() );
    aux_page = new AuxInfoEntryPage (this, multi_sel, synonym, antonym, example, rem, paraphrase, page, name);
    topLayout->addWidget(aux_page);

    page = addPage( i18n("&Multiple Choice") );
    topLayout = new TQVBoxLayout( page, 0, KDialog::spacingHint() );
    mc_page = new MCEntryPage (this, multi_sel, mc, page, "MultipleChoice");
    topLayout->addWidget(mc_page);

    page = addPage( i18n("Con&jugation") );
    topLayout = new TQVBoxLayout( page, 0, KDialog::spacingHint() );
    tense_page = new TenseEntryPage (this, multi_sel, con_prefix, conjugations, page, "Conjugation");
    topLayout->addWidget(tense_page);

    page = addPage( i18n("Compar&ison") );
    topLayout = new TQVBoxLayout( page, 0, KDialog::spacingHint() );
    adj_page = new AdjEntryPage (this, multi_sel, comp, page, "Comparison");
    topLayout->addWidget(adj_page);
  }
  else
  {
    page = addPage( i18n("Co&mmon") );
    topLayout = new TQVBoxLayout( page, 0, KDialog::spacingHint() );
    comm_page = new CommonEntryPage (this, doc, multi_sel, expr, lesson, lessonbox,
                                      lang, type, pronunce, usagelabel,
                                      i18n("Translated &expression in %1:").tqarg(s), querymanager, active,
                                      ipafont, page, name);
    topLayout->addWidget(comm_page);

    page = addPage( i18n("A&dditional") );
    topLayout = new TQVBoxLayout( page, 0, KDialog::spacingHint() );
    aux_page = new AuxInfoEntryPage (this, multi_sel, synonym, antonym, example, rem, paraphrase, page, name);
    topLayout->addWidget(aux_page);

    page = addPage( i18n("&Multiple Choice") );
    topLayout = new TQVBoxLayout( page, 0, KDialog::spacingHint() );
    mc_page = new MCEntryPage (this, multi_sel, mc, page, "MultipleChoice");
    topLayout->addWidget(mc_page);

    page = addPage( i18n("Con&jugation") );
    topLayout = new TQVBoxLayout( page, 0, KDialog::spacingHint() );
    tense_page = new TenseEntryPage (this, multi_sel, con_prefix, conjugations, page, "Conjugation");
    topLayout->addWidget(tense_page);

    page = addPage( i18n("Compar&ison") );
    topLayout = new TQVBoxLayout( page, 0, KDialog::spacingHint() );
    adj_page = new AdjEntryPage (this, multi_sel, comp, page, "Comparison");
    topLayout->addWidget(adj_page);
  }

  page = addPage( i18n("&From Original") );
  topLayout = new TQVBoxLayout( page, 0, KDialog::spacingHint() );
  from_page = new FromToEntryPage (this, multi_sel, f_grd, f_qdate, f_qcount, f_bcount,
                                    f_faux_ami,
                                    i18n("Properties From Original"), page, name);
  topLayout->addWidget(from_page);

  page = addPage( i18n("&To Original") );
  topLayout = new TQVBoxLayout( page, 0, KDialog::spacingHint() );
  to_page   = new FromToEntryPage (this, multi_sel, t_grd, t_qdate, t_qcount, t_bcount,
                                    t_faux_ami,
                                    i18n("Properties to Original"), page, name);
  topLayout->addWidget(to_page);

  updatePages (type);

  connect(comm_page, TQT_SIGNAL(typeSelected(const TQString&)), TQT_SLOT(updatePages(const TQString&)) );

  connect( this, TQT_SIGNAL(user1Clicked()), this, TQT_SLOT(slotUndo()) );
  connect( this, TQT_SIGNAL(applyClicked()), this, TQT_SLOT(slotApply()) );
  connect( this, TQT_SIGNAL(user2Clicked()), this, TQT_SLOT(slotDockVertical()) );
  connect( this, TQT_SIGNAL(user3Clicked()), this, TQT_SLOT(slotDockHorizontal()) );

  connect (comm_page, TQT_SIGNAL(sigModified()), this, TQT_SLOT(slotDisplayModified() ));
  connect (aux_page, TQT_SIGNAL(sigModified()), this, TQT_SLOT(slotDisplayModified() ));
  connect (adj_page, TQT_SIGNAL(sigModified()), this, TQT_SLOT(slotDisplayModified() ));
  connect (mc_page, TQT_SIGNAL(sigModified()), this, TQT_SLOT(slotDisplayModified() ));
  connect (tense_page, TQT_SIGNAL(sigModified()), this, TQT_SLOT(slotDisplayModified() ));

  if (from_page != 0)
    connect (from_page, TQT_SIGNAL(sigModified()), this, TQT_SLOT(slotDisplayModified() ));
  if (to_page != 0)
    connect (to_page, TQT_SIGNAL(sigModified()), this, TQT_SLOT(slotDisplayModified() ));

  enableButtonApply(false);
  enableButton(User1, false);
  comm_page->expr_line->setFocus();
}


void EntryDlg::setData(
  kvoctrainDoc  */*doc*/,
  bool           multi_sel,
  bool           origin,
  grade_t        f_grd,
  grade_t        t_grd,
  count_t        f_qcount,
  count_t        t_qcount,
  count_t        f_bcount,
  count_t        t_bcount,
  time_t         f_qdate,
  time_t         t_qdate,
  TQString        f_faux_ami,
  TQString        t_faux_ami,
  TQString        expr,
  int            lesson,
  TQComboBox     *lessonbox,
  TQString        lang,
  LangSet       &langset,
  TQString        rem,
  TQString        type,
  TQString        pronunce,
  TQString        synonym,
  TQString        antonym,
  TQString        example,
  TQString        usagelabel,
  TQString        paraphrase,
  const          Conjugation &/*con_prefix*/,
  const          Conjugation &conjugations,
  const          Article &/*article*/,
  const          Comparison &comp,
  const          MultipleChoice &mc,
  QueryManager  &querymanager,
  const TQString &title,
  bool           active)
{
  setCaption (kapp->makeStdCaption(title));

  TQString s;
  if (langset.findLongId(lang).isEmpty() )
    s = lang;
  else
    s = langset.findLongId(lang);

  if (origin)
    comm_page->setData(multi_sel, expr, lesson, lessonbox, lang, type, pronunce, usagelabel,
      i18n("Original &expression in %1:").tqarg(s), querymanager, active);
  else
    comm_page->setData(multi_sel, expr, lesson, lessonbox, lang, type, pronunce, usagelabel,
      i18n("Translated &expression in %1:").tqarg(s), querymanager, active);

  adj_page->setData(multi_sel, comp);
  aux_page->setData(multi_sel, synonym, antonym, example, rem, paraphrase);
  mc_page->setData(multi_sel, mc);
  tense_page->setData(multi_sel, conjugations);
  if (from_page != 0)
    from_page->setData(multi_sel, f_grd, f_qdate, f_qcount, f_bcount, f_faux_ami, i18n("Properties From Original"));
  if (to_page != 0)
    to_page->setData(multi_sel, t_grd, t_qdate, t_qcount, t_bcount, t_faux_ami, i18n("Properties to Original"));

  setModified(false);
  updatePages (type);
}


void EntryDlg::updatePages(const TQString &type)
{
  TQString main;
  int pos;
  if ((pos = type.find (TQM_TYPE_DIV)) < 0)  // only use main type
    main = type;
  else
    main = type.left(pos);

  if (main == TQM_VERB) {
    tense_page->setEnabled(EntryDlg::EnableAll);
    adj_page->setEnabled(EntryDlg::EnableNone);
  }
  else if (main == TQM_ADJ) {
    tense_page->setEnabled(EntryDlg::EnableNone);
    adj_page->setEnabled(EntryDlg::EnableAll);
  }
  else {
    tense_page->setEnabled(EntryDlg::EnableNone);
    adj_page->setEnabled(EntryDlg::EnableNone);
  }
}


void EntryDlg::setModified(bool mod)
{
  comm_page->setModified(mod);
  aux_page->setModified(mod);
  mc_page->setModified(mod);
  tense_page->setModified(mod);
  mc_page->setModified(mod);
  adj_page->setModified(mod);
  if (from_page != 0)
    from_page->setModified(mod);
  if (to_page != 0)
    to_page->setModified(mod);
  enableButtonApply(false);
  enableButton(User1, false);
}


void EntryDlg::setEnabled(int enable)
{
  TQString type = comm_page->getType();
  TQString main;
  int pos;
  if ((pos = type.find (TQM_TYPE_DIV)) < 0)  // only use main type
    main = type;
  else
    main = type.left(pos);

  if (enable == EnableOnlyOriginal)
  {
    comm_page->setEnabled(EnableAll);
    aux_page->setEnabled(EnableAll);
    mc_page->setEnabled(EnableAll);
    tense_page->setEnabled(main == TQM_VERB ? EnableAll : EnableNone);
    mc_page->setEnabled(EnableAll);
    adj_page->setEnabled(main == TQM_ADJ ? EnableAll : EnableNone);
    if (from_page != 0)
      from_page->setEnabled(EnableNone);
    if (to_page != 0)
      to_page->setEnabled(EnableNone);
  }
  else
  {
    comm_page->setEnabled(enable);
    aux_page->setEnabled(enable);
    mc_page->setEnabled(enable);
    tense_page->setEnabled(main == TQM_VERB ? enable : EnableNone);
    mc_page->setEnabled(enable);
    adj_page->setEnabled(main == TQM_ADJ ? enable : EnableNone);
    if (from_page != 0)
      from_page->setEnabled(enable);
    if (to_page != 0)
      to_page->setEnabled(enable);
  }
}


void EntryDlg::slotApply()
{
  emit sigEditChoice(EditApply);
}


void EntryDlg::slotUndo()
{
  emit sigEditChoice(EditUndo);
}


bool EntryDlg::isModified()
{
  bool mod = comm_page->isModified()
          || aux_page->isModified()
          || tense_page->isModified()
          || mc_page->isModified()
          || adj_page->isModified();

  if (from_page != 0)
    mod |= from_page->isModified();

  if (to_page != 0)
    mod |= to_page->isModified();

  return mod;
}


void EntryDlg::slotDisplayModified()
{
  enableButtonApply(true);
  enableButton(User1, true);
}


void EntryDlg::setCell(int row, int col, const vector<TQTableSelection>& sel)
{
  edit_row = row;
  edit_col = col;
  selections = sel;
}


void EntryDlg::getCell(int &row, int &col, vector<TQTableSelection>& sel) const
{
  row = edit_row;
  col = edit_col;
  sel = selections;
}


void EntryDlg::slotDockVertical()
{
  if (!docked) {
    oldMainPos = mainwin->pos();
    oldMainSize = mainwin->size();
    docked = true;
  }

  KWinModule info;
  TQRect rect = info.workArea();

  int diff_x = frameGeometry().width()-width();
  int diff_y = frameGeometry().height()-height();
  resize(minimumWidth(), rect.height()-diff_y);
  mainwin->resize(rect.width()-frameGeometry().width()-diff_x,
                  rect.height()-diff_y);
  move (0, 0);
  mainwin->move(frameGeometry().width(), 0);
}


void EntryDlg::slotDockHorizontal()
{
  if (!docked) {
    oldMainPos = mainwin->pos();
    oldMainSize = mainwin->size();
    docked = true;
  }

  KWinModule info;
  TQRect rect = info.workArea();

  int diff_x = frameGeometry().width()-width();
  int diff_y = frameGeometry().height()-height();

  resize(rect.width()-diff_x, minimumHeight());
  mainwin->resize(rect.width()-diff_x,
                  rect.height()-frameGeometry().height()-diff_y);
  move(0, 0);
  mainwin->move (0, frameGeometry().height());
}


EntryDlg::~EntryDlg()
{
  if (docked) {
    docked = false;
    mainwin->resize(oldMainSize);
    mainwin->move(oldMainPos);
  }
}


void EntryDlg::reject ()
{
  emit sigEditChoice(EditCancel);
}


void EntryDlg::closeEvent (TQCloseEvent * /*e*/)
{
  emit sigEditChoice(EditCancel);
}


#include "EntryDlg.moc"

