/***************************************************************************
                        kanswer.h  -  description
                           -------------------
  begin                : Fri Nov 30 2001
  copyright            : (C) 2001 by Matthias Messmer &
                                     Carsten Niehaus &
                                     Robert Gogolok
  email                : bmlmessmer@web.de &
                         cniehaus@gmx.de &
                         mail@robert-gogolok.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KANSWER_H
#define KANSWER_H

// TQt includes

// KDE includes
#include <kdialog.h>

class TQCanvas;
class TQCanvasPixmapArray;
class TQCanvasSprite;
class TQCanvasView;
class TQHBoxLayout;
class TQLabel;

class KAnimation;

class KPushButton;

/**
 * A small dialog, which gives feedback, if the input was wrong or false.
 * It provides reading several sentences from file and selecting by chance.
 *
 * @author Matthias Messmer & Carsten Niehaus & Robert Gogolok
 */
class KAnswer : public KDialog
{
    Q_OBJECT
  TQ_OBJECT
    public:
        /**
        * The constructor doesn't need any parameters but the parent,
        * because it will not be used in any other context.
        *
        * @param parent Parent widget for modal functionality
        */
        KAnswer( TQWidget *parent );

        // public functions
        /** setting/changing feedback text and pic */
        void setAnswer( int modus );

    public slots:
        /** reimplemented: close the window after some time */
        void timerEvent( TQTimerEvent * );
        void accept();
        
        int exec();

    private:
        // private functions
        /** Loads feadback sentences from file */
        void loadAnswers();
        /** Gets a answer by chance for well solved tasks. */
        TQString getRightAnswer();
        /** Gets a answer by chance for not solved tasks. */
        TQString getWrongAnswer();

        // GUI widgets
        /** Label for the answer text */
        TQLabel *TextLabelAnswer;
        /** OK button */
        KPushButton *ButtonOK;

        /** List of feedback text for well solved tasks. */
        TQStringList rightAnswerList;
        /** List of feedback text for not solved tasks. */
        TQStringList wrongAnswerList;

        TQHBoxLayout *mainLayout;

        KAnimation *right_animation;
        KAnimation *wrong_animation;
        
        int advPer;

        TQCanvasView *canvas_view;
        TQCanvasPixmapArray *pixs;
        TQCanvas *canvas;

        void setupSprite();
};

#endif
