// Demonstrates that auto-boxing of foreign C++ objects works.
// Set QTCSHARP_DEBUG to true in your environment to see this work.
//
// TODO
// o Turn this into an nunit test.
// o Mono won't let this test call LookupObject because
//   it is marked 'internal', even though they're both
//   in the same namespace. Mono bug?

namespace Qt {

	using Qt;
	using System;

	public class LookupTest : TQVBox, IDisposable {
		
		public LookupTest() : base (null)
		{
			TQPushButton button = new TQPushButton ("Quit", this);
			TQPushButton button2 = (TQPushButton)QtSupport.LookupObject (button.Ptr); // Lookup a child object that exists in C#

			if (button.GetHashCode () != button2.GetHashCode ())
				Console.WriteLine ("ERROR: Hash codes differ for button and button2!");

			TQSize size = button2.SizeHint (); // Wrap a non-C# object. Lookup is called from the C# sizeHint method.
			TQSize size2 = (TQSize)QtSupport.LookupObject (size.Ptr);

			if (size.GetHashCode () != size2.GetHashCode ())
				Console.WriteLine ("ERROR: Hash codes differ for size and size2!");

			Connect (button, TQT_SIGNAL ("clicked()"), TQObject.qApp, TQT_SLOT ("Quit()"));
		}

		public static void Main (string[] args)
		{
			TQApplication a = new TQApplication (args);
			LookupTest lt = new LookupTest ();
			a.SetMainWidget (lt);
			lt.Show ();

			LookupTest lt2 = (LookupTest)QtSupport.LookupObject (lt.Ptr); // Lookup a root object that exists in C#

			if (lt.GetHashCode () != lt2.GetHashCode ())
				Console.WriteLine ("ERROR: Hash codes differ for lt and lt2!");

			a.Exec ();
			lt.Dispose ();
		}
	}
}
