// A Qt to C# binding generator.
//
// Copyright (C) 2002  Adam Treat (manyoso@yahoo.com)
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

using System;
using System.Collections;

namespace QtCSharp {

	public class QTypeMap {

		Hashtable arraymap, mastermap, pinvoketypes, pinvokecalltypes, csharptypes, overloadtypes, reserved, interfaces;

		public QTypeMap ()
		{
			arraymap = new Hashtable ();
			arraymap.Add ("void*", "int[]");
			arraymap.Add ("void *", "int[]");
			arraymap.Add ("int*", "int[]");
			arraymap.Add ("int *", "int[]");
			arraymap.Add ("double*", "double[]");
			arraymap.Add ("double *", "double[]");
			arraymap.Add ("short*", "short[]");
			arraymap.Add ("short *", "short[]");
			arraymap.Add ("char**", "string[]");
			arraymap.Add ("char **", "string[]");
			arraymap.Add ("char*", "string");
			arraymap.Add ("uchar**", "string[]");
			arraymap.Add ("uchar **", "string[]");

			mastermap = new Hashtable ();
			mastermap.Add ("void", "void");
		//	mastermap.Add ("TQByteArray", "byte[]");
			mastermap.Add ("TQBitArray", "byte[]");
			mastermap.Add ("uchar", "string");
			mastermap.Add ("unsigned int", "uint");
			mastermap.Add ("unsigned short", "ushort");
			mastermap.Add ("unsigned long", "ulong");
			mastermap.Add ("unsigned char", "string");
			mastermap.Add ("HANDLE", "uint");
			mastermap.Add ("HBITMAP", "uint");
			mastermap.Add ("HCURSOR", "uint");
			mastermap.Add ("HDC", "uint");
			mastermap.Add ("HFONT", "uint");
			mastermap.Add ("HPALETTE", "uint");
			mastermap.Add ("HRGN", "uint");
			mastermap.Add ("Display", "IntPtr");
			mastermap.Add ("Q_REFCOUNT bool", "bool");
			mastermap.Add ("EventRef", "IntPtr");
			mastermap.Add ("MSG", "IntPtr");
			mastermap.Add ("XEvent", "IntPtr");
			mastermap.Add ("QWSEvent", "IntPtr");
			mastermap.Add ("GDHandle", "IntPtr");
			mastermap.Add ("QRgb", "int");
			mastermap.Add ("QWSDecoration", "IntPtr");
			mastermap.Add ("QTextParag", "IntPtr");
			mastermap.Add ("Qt.HANDLE", "IntPtr");
			mastermap.Add ("QUObject", "IntPtr");
			mastermap.Add ("QGfx", "IntPtr");
			mastermap.Add ("QRESULT", "long");
			mastermap.Add ("QUnknownInterface", "IntPtr");
			mastermap.Add ("TQPtrCollection.Item", "int");
			mastermap.Add ("type", "IntPtr");
			mastermap.Add ("array_data", "IntPtr");
			mastermap.Add ("bitarr_data", "IntPtr");
			mastermap.Add ("Offset", "int");
			mastermap.Add ("Q_INT16", "short");
			mastermap.Add ("Q_INT32", "int");
			mastermap.Add ("Q_INT8", "char");
			mastermap.Add ("Q_LONG", "long");
			mastermap.Add ("Q_PACKED", "uint");
			mastermap.Add ("Q_UINT16", "ushort");
			mastermap.Add ("Q_UINT32", "uint");
			mastermap.Add ("Q_UINT8", "char");
			mastermap.Add ("Q_ULONG", "long");
			mastermap.Add ("QStyleHintReturn", "IntPtr");
			mastermap.Add ("QFileInfoList", "IntPtr");
			mastermap.Add ("QDomNodePrivate", "IntPtr");
			mastermap.Add ("GUID", "System.Guid");
			mastermap.Add ("FILE", "string");
			mastermap.Add ("EncoderFn", "int");
			mastermap.Add ("DecoderFn", "int");
			mastermap.Add ("QDiskFont", "IntPtr");
			mastermap.Add ("pointer", "IntPtr");
			mastermap.Add ("T", "IntPtr");
			mastermap.Add ("T1", "IntPtr");
			mastermap.Add ("T2", "IntPtr");
			mastermap.Add ("Iterator", "IntPtr");
			mastermap.Add ("iterator", "IntPtr");
			mastermap.Add ("_iterator", "IntPtr");
			mastermap.Add ("reference", "IntPtr");
			mastermap.Add ("_reference", "IntPtr");
			mastermap.Add ("ConstIterator", "int");
			mastermap.Add ("QWSDisplay", "IntPtr");
			mastermap.Add ("CGContextRef", "IntPtr");
			mastermap.Add ("WId", "uint");
			mastermap.Add ("QWidgetMapper", "IntPtr");
			mastermap.Add ("size_type", "int");
			mastermap.Add ("Item", "IntPtr");
			mastermap.Add ("image_io_handler", "int");
			mastermap.Add ("QCOORD", "short");
			mastermap.Add ("key_type", "IntPtr");
			mastermap.Add ("K", "IntPtr");
			mastermap.Add ("NodePtr", "int");
			mastermap.Add ("QTextFormat", "IntPtr");
			mastermap.Add ("QTextDocument", "IntPtr");
			mastermap.Add ("QTextCursor", "IntPtr");
			mastermap.Add ("_NPStream", "IntPtr");
			mastermap.Add ("PID", "long");
			mastermap.Add ("Region", "int");
			mastermap.Add ("RgnHandle", "IntPtr");
			mastermap.Add ("QRemoteInterface", "IntPtr");
			mastermap.Add ("mode_t", "int");
			mastermap.Add ("TQSqlFieldInfo", "IntPtr");
			mastermap.Add ("TQSqlRecordInfo", "IntPtr");
			mastermap.Add ("QSqlRecordPrivate", "IntPtr");
			mastermap.Add ("QTSMFI", "int");
			mastermap.Add ("Widget", "TQWidget");
			mastermap.Add ("WidgetClass", "int");
			mastermap.Add ("ArgList", "int");
			mastermap.Add ("Cardinal", "int");
			mastermap.Add ("XrmOptionDescRec", "IntPtr");
			mastermap.Add ("size_t", "int");
			mastermap.Add ("ULONG_MAX", "UInt64.MaxValue");

			// Enums
			mastermap.Add ("Event", "TQAccessible.Event");
			mastermap.Add ("Role", "TQAccessible.Role");
			mastermap.Add ("NavDirection", "TQAccessible.NavDirection");
			mastermap.Add ("Text", "TQAccessible.Text");
			mastermap.Add ("ColorSpec", "TQApplication.ColorSpec");
			mastermap.Add ("ToggleState", "TQButton.ToggleState");
			mastermap.Add ("RttiValues", "TQCanvasItem.RttiValues");
			mastermap.Add ("FrameAnimationType", "TQCanvasSprite.FrameAnimationType");
			mastermap.Add ("Category", "TQChar.Category");
			mastermap.Add ("Decomposition", "TQChar.Decomposition");
			mastermap.Add ("Joining", "TQChar.Joining");
			mastermap.Add ("CombiningClass", "TQChar.CombiningClass");
			mastermap.Add ("Spec", "TQColor.Spec");
			mastermap.Add ("ColorRole", "TQColorGroup.ColorRole");
			mastermap.Add ("Boundary", "TQDataBrowser.Boundary");
			mastermap.Add ("ByteOrder", "TQDataStream.ByteOrder");
			mastermap.Add ("Refresh", "TQDataTable.Refresh");
			mastermap.Add ("Order", "QDateEdit.Order");
			mastermap.Add ("DialogCode", "TQDialog.DialogCode");
			mastermap.Add ("FilterSpec", "TQDir.FilterSpec");
			mastermap.Add ("SortSpec", "TQDir.SortSpec");
			mastermap.Add ("RecordType", "TQDns.RecordType");
			mastermap.Add ("HandlePosition", "TQDockArea.HandlePosition");
			mastermap.Add ("Place", "TQDockWindow.Place");
			mastermap.Add ("CloseMode", "TQDockWindow.CloseMode");
			mastermap.Add ("NodeType", "TQDomNode.NodeType");
			mastermap.Add ("DragMode", "TQDragObject.DragMode");
			mastermap.Add ("Action", "TQDropEvent.Action");
			mastermap.Add ("ViewMode", "TQFileDialog.ViewMode");
			mastermap.Add ("PreviewMode", "TQFileDialog.PreviewMode");
			mastermap.Add ("PermissionSpec", "TQFileInfo.PermissionSpec");
			mastermap.Add ("StyleStrategy", "TQFont.StyleStrategy");
			mastermap.Add ("Weight", "TQFont.Weight");
			mastermap.Add ("Script", "TQFont.Script");
			mastermap.Add ("Shadow", "TQFrame.Shadow");
			mastermap.Add ("FormatOption", "TQGL.FormatOption");
			mastermap.Add ("Corner", "TQGridLayout.Corner");
			mastermap.Add ("Size", "TQIconSet.Size");
			mastermap.Add ("Arrangement", "TQIconView.Arrangement");
			mastermap.Add ("ItemTextPos", "TQIconView.ItemTextPos");
			mastermap.Add ("Endian", "TQImage.Endian");
			mastermap.Add ("ScaleMode", "TQImage.ScaleMode");
			mastermap.Add ("PaintDeviceFlags", "TQInternal.PaintDeviceFlags");
			mastermap.Add ("Rules", "TQJpUnicodeConv.Rules");
			mastermap.Add ("SegmentStyle", "QLCDNumber.SegmentStyle");
			mastermap.Add ("LayoutMode", "TQListBox.LayoutMode");
			mastermap.Add ("WidthMode", "TQListView.WidthMode");
			mastermap.Add ("RenameAction", "TQListView.RenameAction");
			mastermap.Add ("DockWindows", "TQMainWindow.DockWindows");
			mastermap.Add ("Color", "QMapNodeBase.Color");
			mastermap.Add ("Separator", "TQMenuBar.Separator");
			mastermap.Add ("Icon", "TQMessageBox.Icon");
			mastermap.Add ("Access", "QMetaData.Access");
			mastermap.Add ("Flags", "TQMetaProperty.Flags");
			mastermap.Add ("Status", "TQMovie.Status");
			mastermap.Add ("InstanceMode", "QNPInstance.InstanceMode");
			mastermap.Add ("StreamMode", "QNPInstance.StreamMode");
			mastermap.Add ("Operation", "TQNetworkProtocol.Operation");
			mastermap.Add ("ConnectionState", "TQNetworkProtocol.ConnectionState");
			mastermap.Add ("DisposalMethod", "QPNGImageWriter.DisposalMethod");
			mastermap.Add ("PDevCmd", "TQPaintDevice.PDevCmd");
			mastermap.Add ("CoordinateMode", "TQPainter.CoordinateMode");
			mastermap.Add ("TextDirection", "TQPainter.TextDirection");
			mastermap.Add ("ColorGroup", "TQPalette.ColorGroup");
			mastermap.Add ("Optimization", "TQPixmap.Optimization");
			mastermap.Add ("Edge", "TQPolygonScanner.Edge");
			mastermap.Add ("PrinterMode", "TQPrinter.PrinterMode");
			mastermap.Add ("PageSize", "TQPrinter.PageSize");
			mastermap.Add ("PageOrder", "TQPrinter.PageOrder");
			mastermap.Add ("PaperSource", "TQPrinter.PaperSource");
			mastermap.Add ("Communication", "TQProcess.Communication");
			mastermap.Add ("RegionType", "TQRegion.RegionType");
			mastermap.Add ("ResizePolicy", "TQScrollView.ResizePolicy");
			mastermap.Add ("ScrollBarMode", "TQScrollView.ScrollBarMode");
			mastermap.Add ("RestartHint", "QSessionManager.RestartHint");
			mastermap.Add ("System", "TQSettings.System");
			mastermap.Add ("SizeType", "TQSizePolicy.SizeType");
			mastermap.Add ("ExpandData", "TQSizePolicy.ExpandData");
			mastermap.Add ("TickSetting", "TQSlider.TickSetting");
			mastermap.Add ("Op", "TQSql.Op");
			mastermap.Add ("Location", "TQSql.Location");
			mastermap.Add ("Confirm", "TQSql.Confirm");
			mastermap.Add ("DriverFeature", "TQSqlDriver.DriverFeature");
			mastermap.Add ("SectionFlags", "TQString.SectionFlags");
			mastermap.Add ("PrimitiveElement", "TQStyle.PrimitiveElement");
			mastermap.Add ("StyleFlags", "TQStyle.StyleFlags");
			mastermap.Add ("SFlags", "TQStyle.StyleFlags");
			mastermap.Add ("ControlElement", "TQStyle.ControlElement");
			mastermap.Add ("SubRect", "TQStyle.SubRect");
			mastermap.Add ("ComplexControl", "TQStyle.ComplexControl");
			mastermap.Add ("SubControl", "TQStyle.SubControl");
			mastermap.Add ("SCFlags", "TQStyle.SubControl");
			mastermap.Add ("PixelMetric", "TQStyle.PixelMetric");
			mastermap.Add ("ContentsType", "TQStyle.ContentsType");
			mastermap.Add ("StylePixmap", "TQStyle.StylePixmap");
			mastermap.Add ("StyleOptionDefault", "TQStyleOption.StyleOptionDefault");
			mastermap.Add ("AdditionalStyleValues", "TQStyleSheetItem.AdditionalStyleValues");
			mastermap.Add ("DisplayMode", "TQStyleSheetItem.DisplayMode");
			mastermap.Add ("WhiteSpaceMode", "TQStyleSheetItem.WhiteSpaceMode");
			mastermap.Add ("Margin", "TQStyleSheetItem.Margin");
			mastermap.Add ("ListStyle", "TQStyleSheetItem.ListStyle");
			mastermap.Add ("FocusStyle", "TQTable.FocusStyle");
			mastermap.Add ("EditMode", "TQTable.EditMode");
			mastermap.Add ("EditType", "TQTableItem.EditType");
			mastermap.Add ("TabletDevice", "TQTabletEvent.TabletDevice");
			mastermap.Add ("KeyboardAction", "TQTextEdit.KeyboardAction");
			mastermap.Add ("CursorAction", "TQTextEdit.CursorAction");
			mastermap.Add ("SaveMode", "QTranslator.SaveMode");
			mastermap.Add ("Prefix", "QTranslatorMessage.Prefix");
			mastermap.Add ("FocusPolicy", "TQWidget.FocusPolicy");
			mastermap.Add ("BackgroundOrigin", "TQWidget.BackgroundOrigin");
			mastermap.Add ("ButtonState", "Qt.ButtonState");
			mastermap.Add ("AlignmentFlags", "Qt.AlignmentFlags");
			mastermap.Add ("TextFlags", "Qt.TextFlags");
			mastermap.Add ("WidgetState", "Qt.WidgetState");
			mastermap.Add ("WState", "Qt.WidgetState");
			mastermap.Add ("WidgetFlags", "Qt.WidgetFlags");
			mastermap.Add ("WFlags", "Qt.WidgetFlags");
			mastermap.Add ("ImageConversionFlags", "Qt.ImageConversionFlags");
			mastermap.Add ("BGMode", "Qt.BGMode");
			mastermap.Add ("PaintUnit", "Qt.PaintUnit");
			mastermap.Add ("GUIStyle", "Qt.GUIStyle");
			mastermap.Add ("Modifier", "Qt.Modifier");
			mastermap.Add ("Key", "Qt.Key");
			mastermap.Add ("ArrowType", "Qt.ArrowType");
			mastermap.Add ("RasterOp", "Qt.RasterOp");
			mastermap.Add ("PenStyle", "Qt.PenStyle");
			mastermap.Add ("PenCapStyle", "Qt.PenCapStyle");
			mastermap.Add ("PenJoinStyle", "Qt.PenJoinStyle");
			mastermap.Add ("BrushStyle", "Qt.BrushStyle");
			mastermap.Add ("WindowsVersion", "Qt.WindowsVersion");
			mastermap.Add ("UIEffect", "Qt.UIEffect");
			mastermap.Add ("CursorShape", "Qt.CursorShape");
			mastermap.Add ("TextFormat", "Qt.TextFormat");
			mastermap.Add ("Dock", "Qt.Dock");
			mastermap.Add ("DateFormat", "Qt.DateFormat");
			mastermap.Add ("BackgroundMode", "Qt.BackgroundMode");
			mastermap.Add ("StringComparisonMode", "Qt.StringComparisonMode");
			mastermap.Add ("ComparisonFlags", "Qt.StringComparisonMode");
			
			// We need to make sure all params use the interfaces, ie IQPaintDevice
			/*mastermap.Add ("QAccessibleFactoryInterface", "IQAccessibleFactory");
			mastermap.Add ("QAccessibleInterface", "IQAccessible");*/
			mastermap.Add ("TQPaintDevice", "IQPaintDevice");
			/*mastermap.Add ("TQMenuData", "IQMenuData");
			mastermap.Add ("TQRangeControl", "IQRangeControl");
			mastermap.Add ("TQMimeSource", "IQMimeSource");
			mastermap.Add ("TQLayoutItem", "IQLayoutItem");
			mastermap.Add ("TQUrl", "IQUrl");
			mastermap.Add ("QIODevice", "IQIODevice");
			mastermap.Add ("TQXmlContentHandler", "IQXmlContentHandler");
			mastermap.Add ("TQXmlErrorHandler", "IQXmlErrorHandler");
			mastermap.Add ("TQXmlDTDHandler", "IQXmlDTDHandler");
			mastermap.Add ("TQXmlEntityResolver", "IQXmlEntityResolver");
			//mastermap.Add ("TQXmlLexicalHandler", "IQXmlLexicalHandler");
			mastermap.Add ("TQXmlDeclHandler", "IQXmlDeclHandler");
			mastermap.Add ("QwAbsSpriteFieldView", "IQwAbsSpriteFieldView");
			mastermap.Add ("TQSqlQuery", "IQSqlQuery");
			mastermap.Add ("QFeatureListInterface", "IQFeatureList");
			mastermap.Add ("QUnknownInterface", "IQUnknown");
			mastermap.Add ("QShared", "IQShared");*/

			// Key Duplication
			//mastermap.Add ("Direction", "TQBoxLayout.Direction");
			//mastermap.Add ("Direction", "TQChar.Direction");
			//mastermap.Add ("Reason", "TQContextMenuEvent.Reason");
			//mastermap.Add ("Reason", "TQFocusEvent.Reason");
			//mastermap.Add ("Reason", "QNPInstance.Reason");
			//mastermap.Add ("Mode", "TQFileDialog.Mode");
			//mastermap.Add ("Mode", "TQIconSet.Mode");
			//mastermap.Add ("Mode", "QLCDNumber.Mode");
			//mastermap.Add ("Mode", "TQSqlCursor.Mode");
			//mastermap.Add ("Shape", "TQFrame.Shape");
			//mastermap.Add ("Shape", "TQTabBar.Shape");
			//mastermap.Add ("KeyType", "TQGCache.KeyType");
			//mastermap.Add ("KeyType", "TQGDict.KeyType");
			//mastermap.Add ("State", "TQAccessible.State");
			//mastermap.Add ("State", "TQNetworkProtocol.State");
			//mastermap.Add ("State", "TQSocket.State");
			//mastermap.Add ("State", "TQValidator.State");
			//mastermap.Add ("ResizeMode", "TQIconView.ResizeMode");
			//mastermap.Add ("ResizeMode", "TQLayout.ResizeMode");
			//mastermap.Add ("ResizeMode", "TQListView.ResizeMode");
			//mastermap.Add ("ResizeMode", "TQListView.ResizeMode");
			//mastermap.Add ("EchoMode", "TQLineEdit.EchoMode");
			//mastermap.Add ("EchoMode", "QtMultiLineEdit.EchoMode");
			//mastermap.Add ("ColorMode", "TQApplication.ColorMode");
			//mastermap.Add ("ColorMode", "TQPrinter.ColorMode");
			//mastermap.Add ("ColorMode", "TQPixmap.ColorMode");
			//mastermap.Add ("SelectionMode", "TQIconView.SelectionMode");
			//mastermap.Add ("SelectionMode", "TQListBox.SelectionMode");
			//mastermap.Add ("SelectionMode", "TQListView.SelectionMode");
			//mastermap.Add ("SelectionMode", "TQTable.SelectionMode");
			//mastermap.Add ("Error", "TQSocket.Error");
			//mastermap.Add ("Error", "TQSocketDevice.Error");
			//mastermap.Add ("Error", "TQNetworkProtocol.Error");
			//mastermap.Add ("ButtonSymbols", "TQSpinBox.ButtonSymbols");
			//mastermap.Add ("ButtonSymbols", "TQSpinWidget.ButtonSymbols");
			//mastermap.Add ("StyleHint", "TQStyle.StyleHint");
			//mastermap.Add ("StyleHint", "TQFont.StyleHint");
			//mastermap.Add ("Encoding", "TQApplication.Encoding");
			//mastermap.Add ("Encoding", "TQTextStream.Encoding");
			//mastermap.Add ("VerticalAlignment", "TQTextEdit.VerticalAlignment");
			//mastermap.Add ("VerticalAlignment", "TQStyleSheetItem.VerticalAlignment");
			//mastermap.Add ("Orientation", "TQPrinter.Orientation");
			//mastermap.Add ("Orientation", "Qt.Orientation");
			//mastermap.Add ("WrapPolicy", "TQTextEdit.WrapPolicy");
			//mastermap.Add ("WrapPolicy", "QtMultiLineEdit.WrapPolicy");
			//mastermap.Add ("WordWrap", "TQTextEdit.WordWrap");
			//mastermap.Add ("WordWrap", "QtMultiLineEdit.WordWrap");

			// These are here in case we need to override the mastermap
			pinvoketypes = new Hashtable ();
			pinvokecalltypes = new Hashtable ();
			csharptypes = new Hashtable ();
			overloadtypes = new Hashtable ();

			// These are reserved keywords.
			reserved = new Hashtable ();
			reserved.Add ("lock", "Q_lock");
			reserved.Add ("object", "Q_object");
			reserved.Add ("ref", "Q_ref");
			reserved.Add ("base", "Q_base");
			reserved.Add ("string", "Q_string");
			reserved.Add ("const", "Q_const");
			reserved.Add ("event", "Q_event");

			// The allowed interfaces
			interfaces = new Hashtable ();
			interfaces.Add ("QAccessibleFactoryInterface", "IQAccessibleFactory");
			interfaces.Add ("QAccessibleInterface", "IQAccessible");
			interfaces.Add ("TQPaintDevice", "IQPaintDevice");
			interfaces.Add ("TQMenuData", "IQMenuData");
			interfaces.Add ("TQRangeControl", "IQRangeControl");
			interfaces.Add ("TQMimeSource", "IQMimeSource");
			interfaces.Add ("TQLayoutItem", "IQLayoutItem");
			interfaces.Add ("TQUrl", "IQUrl");
			interfaces.Add ("QIODevice", "IQIODevice");
			interfaces.Add ("TQXmlContentHandler", "IQXmlContentHandler");
			interfaces.Add ("TQXmlErrorHandler", "IQXmlErrorHandler");
			interfaces.Add ("TQXmlDTDHandler", "IQXmlDTDHandler");
			interfaces.Add ("TQXmlEntityResolver", "IQXmlEntityResolver");
			//interfaces.Add ("TQXmlLexicalHandler", "IQXmlLexicalHandler");
			interfaces.Add ("TQXmlDeclHandler", "IQXmlDeclHandler");
			interfaces.Add ("QwAbsSpriteFieldView", "IQwAbsSpriteFieldView");
			interfaces.Add ("TQSqlQuery", "IQSqlQuery");
			interfaces.Add ("QFeatureListInterface", "IQFeatureList");
			interfaces.Add ("QUnknownInterface", "IQUnknown");
			interfaces.Add ("QShared", "IQShared");
		}

		public string PinvokeType (string str)
		{
			if ((string)mastermap[str] != null)
				if((string)pinvoketypes[(string)mastermap[str]] != null)
					return (string)pinvoketypes[(string)mastermap[str]];
				else
					return (string)mastermap[str];
			else if ((string)pinvoketypes[str] != null)
				return (string)pinvoketypes[str];
			else
				return str;
		}

		public string PinvokeCallType (string str)
		{

			if ((string)mastermap[str] != null)
				if((string)pinvokecalltypes[(string)mastermap[str]] != null)
					return (string)pinvokecalltypes[(string)mastermap[str]];
				else
					return (string)mastermap[str];
			else if ((string)pinvokecalltypes[str] != null)
				return (string)pinvokecalltypes[str];
			else
				return str;
		}

		public string CSharpType (string str)
		{
			if ((string)mastermap[str] != null)
				if((string)csharptypes[(string)mastermap[str]] != null)
					return (string)csharptypes[(string)mastermap[str]];
				else
					return (string)mastermap[str];
			else if ((string)csharptypes[str] != null)
				return (string)csharptypes[str];
			else
				return str;
		}

		public string OverloadType (string str)
		{
			if ((string)mastermap[str] != null)
				if((string)overloadtypes[(string)mastermap[str]] != null)
					return (string)overloadtypes[(string)mastermap[str]];
				else
					return (string)mastermap[str];
			else if ((string)overloadtypes[str] != null)
				return (string)overloadtypes[str];
			else
				return str;
		}

		public string ArrayType (string str)
		{
			if ((string)arraymap[str] != null)
				return (string)arraymap[str];
			else
				return str;
		}

		public string ReservedType (string str)
		{
			if ((string)reserved[str] != null)
				return (string)reserved[str];
			else
				return str;
		}

		public string ReturnType (string str)
		{
			if ((string)reserved[str] != null)
				return (string)reserved[str];
			else
				return str;
		}

		public string InterfaceType (string str)
		{
			if ((string)interfaces[str] != null)
				return (string)interfaces[str];
			else
				return str;
		}
	}
}
