// Qt# tutorial 5
// Based on the Qt tutorial
// Implemented by Marcus Urban

using System;
using Qt;

public class MyWidget : TQVBox {

	public MyWidget (TQWidget parent, String name) : base (parent, name)
	// In C++, parent and name have default values of 0 (null pointer)
	{
		TQPushButton quit = new TQPushButton ("Quit", this, "quit");
		quit.SetFont ( new TQFont ("Times", 18, TQFont.Weight.Bold) );
		
		TQObject.Connect ( quit, TQT_SIGNAL ("clicked()"), qApp, TQT_SLOT ("Quit()") );
		
		TQLCDNumber lcd = new TQLCDNumber (2, this, "lcd" );
		
		TQSlider slider = new TQSlider (Orientation.Horizontal, this, "slider");
		// Note that Orientation is defined in the Qt class
		slider.SetRange (0, 99);
		slider.SetValue (0);

		Connect ( slider, TQT_SIGNAL ("valueChanged(int)"), lcd, TQT_SLOT ("Display(int)") );
	}
	
	public MyWidget (TQWidget parent) : this (parent, "") {}
	public MyWidget () : this (null, "") {}
	// Note that it was necessary to use an empty string ("")
	// in the above. Using null does not work at runtime.
}

public class Example {

	public static int Main (String[] args)
	{
		TQApplication a = new TQApplication (args);
		
		MyWidget w = new MyWidget ();
		a.SetMainWidget (w);
		w.Show ();
		return a.Exec ();
	}
}
