/****************************************************************************
** 
**
** Definition of TQBrush class
**
** Created : 940112
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the kernel module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef QBRUSH_H
#define QBRUSH_H

#ifndef QT_H
#include "tqcolor.h"
#include "tqshared.h"
#endif // QT_H


class Q_EXPORT TQBrush: public Qt
{
friend class TQPainter;
public:
    TQBrush();
    TQBrush( BrushStyle );
    TQBrush( const TQColor &, BrushStyle=SolidPattern );
    TQBrush( const TQColor &, const TQPixmap & );
    TQBrush( const TQBrush & );
   ~TQBrush();
    TQBrush &operator=( const TQBrush & );

    BrushStyle	style()	 const		{ return data->style; }
    void	setStyle( BrushStyle );
    const TQColor &color()const		{ return data->color; }
    void	setColor( const TQColor & );
    TQPixmap    *pixmap() const		{ return data->pixmap; }
    void	setPixmap( const TQPixmap & );

    bool	operator==( const TQBrush &p ) const;
    bool	operator!=( const TQBrush &b ) const
					{ return !(operator==(b)); }

private:
    QBrush	copy()	const;
    void	detach();
    void	init( const TQColor &, BrushStyle );
    struct QBrushData : public QShared {	// brush data
	BrushStyle style;
	QColor	  color;
	QPixmap	 *pixmap;
    } *data;
};


/*****************************************************************************
  TQBrush stream functions
 *****************************************************************************/

#ifndef QT_NO_DATASTREAM
Q_EXPORT TQDataStream &operator<<( TQDataStream &, const TQBrush & );
Q_EXPORT TQDataStream &operator>>( TQDataStream &, TQBrush & );
#endif

#endif // QBRUSH_H
