// -*- c++ -*-

/*
 *  Copyright (C) 2003, Ian Reinhart Geiser <geiseri@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#ifndef KJSEMBED_QPROCESS_PLUGIN_H
#define KJSEMBED_QPROCESS_PLUGIN_H

#include <kjsembed/jsbindingplugin.h>
#include <kjsembed/jsproxy_imp.h>
#include <tqprocess.h>
#include <tqdir.h>

namespace KJSEmbed {
namespace Bindings {

class ProcessLoader : public JSBindingPlugin
{
public:
    ProcessLoader( TQObject *parent, const char *name, const TQStringList &args );
    virtual ~ProcessLoader(){;}
    KJS::Object createBinding(KJSEmbedPart *jspart, KJS::ExecState *exec, const KJS::List &args) const;
};


class ProcessImp : public TQProcess {

Q_OBJECT

    /** Identifiers for the methods provided by this class. */
	enum Communication { Stdin = 0x01, Stdout = 0x02, Stderr = 0x04, DupStderr = 0x08 };

	Q_PROPERTY(TQStringList arguments READ arguments WRITE setArguments )
	Q_PROPERTY(Communication communication READ communication WRITE setCommunication)
	Q_PROPERTY(bool canReadLineStdout READ canReadLineStdout )
	Q_PROPERTY(bool canReadLineStderr READ canReadLineStderr )
	Q_PROPERTY(bool isRunning READ isRunning )
	Q_PROPERTY(bool normalExit READ normalExit )
	Q_PROPERTY(int exitStatus READ exitStatus )
	Q_ENUMS(Communication)

public:
    ProcessImp( TQObject *parent = 0, const char *name = 0);
    virtual ~ProcessImp();

    TQStringList arguments() const;
    void setArguments( const TQStringList args);

    Communication communication() const;
    void setCommunication( Communication comm);

    bool canReadLineStdout() const;
    bool canReadLineStderr() const;
    bool isRunning() const;
    bool normalExit() const;
    int exitStatus() const;

public slots:
	bool start();
	virtual TQString readLineStdout ();
	virtual TQString readLineStderr ();
	TQDir workingDirectory () const;
	void setWorkingDirectory ( const TQDir & dir );
	void addArgument ( const TQString & arg );
};

} // namespace
} // namespace

#endif // KJSEMBED_QPROCESS_PLUGIN_H
