/*
*  Copyright (C) 2003, Ian Reinhart Geiser <geiseri@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#include "kconfig_imp.h"

#include <kjsembed/global.h>

#ifndef QT_ONLY
#include <kconfig.h>
#include <kstddirs.h>
#include <kapplication.h>
#include "kconfig_imp.moc"
#else
#include <tqsettings.h>
#endif
namespace KJSEmbed {
namespace Bindings {

Config::Config( TQObject *parent, const char *name)
    : BindingObject(parent, name)
{

#ifndef QT_ONLY
	if( name == 0)
		m_config = kapp->config();
	else
		m_config = new KConfig(name);
	if( !m_config->checkConfigFilesWritable(true) )
	{
	  kdWarning( 80001 ) << "Could not write to config file." << endl;
	}
#else
	m_config = new TQSettings();
	if( name == 0)
	  m_name = "qjcmd";
	else
	  m_name = name;
	m_config->setPath( "QJSEmbed",m_name, TQSettings::User );
	m_forceGlobal = false;
#endif
}

/*
Config::Config( TQObject *parent, const char *name , const TQString& confName)
        : BindingObject(parent, name)
{
    TQString fileName = ::locate("kde_config", confName);
    m_config = new KConfig(fileName);
}
*/
Config::~Config()
{
#ifndef QT_ONLY
	if( kapp->config() != m_config )
#endif
    delete m_config;
}

void Config::setDesktopGroup()
{
#ifndef QT_ONLY
    m_config->setDesktopGroup();
#else
    m_config->resetGroup();
    m_config->beginGroup("/Desktop Entry");
#endif 
}

void Config::setGroup(const TQString& group)
{
#ifndef QT_ONLY
    m_config->setGroup(group);
#else
   m_config->resetGroup();
   m_config->beginGroup(group);
#endif 
}

TQString Config::group()
{
    return m_config->group();
}

TQStringList Config::groupList()
{
#ifndef QT_ONLY
    return m_config->groupList();
#else
    m_config->resetGroup();
    return m_config->subkeyList(group());
#endif 
}

TQString Config::locale()
{
#ifndef QT_ONLY
    return m_config->locale();
#else
    return "C";
#endif
}

void Config::setForceGlobal( bool force )
{
#ifndef QT_ONLY
    m_config->setForceGlobal(force);
#else
    m_forceGlobal = force; 
    m_config->setPath( "QJSEmbed",m_name, (force)?TQSettings::Global:TQSettings::User );
#endif
}

bool Config::forceGlobal( ) const
{
#ifndef QT_ONLY
    return m_config->forceGlobal();
#else
    return m_forceGlobal;
#endif
}

void Config::setDollarExpansion( bool _bExpand )
{
#ifndef QT_ONLY
    m_config->setDollarExpansion(_bExpand);
#else
    Q_UNUSED(_bExpand);
#endif 
}

bool Config::isDollarExpansion() const
{
#ifndef QT_ONLY
    return m_config->isDollarExpansion();
#else
    return false;
#endif 
}

void Config::setReadOnly(bool _ro)
{
#ifndef QT_ONLY
    m_config->setReadOnly(_ro);
#else
    Q_UNUSED(_ro);
#endif 
}

bool Config::isReadOnly() const
{
#ifndef QT_ONLY
    return m_config->isReadOnly();
#else
    return false;
#endif
}

void Config::setReadDefaults(bool b)
{
#ifndef QT_ONLY
    m_config->setReadDefaults(b);
#else
    Q_UNUSED(b);
#endif
}

bool Config::readDefaults() const
{
#ifndef QT_ONLY
    return m_config->readDefaults();
#else
    return false;
#endif
}

void Config::rollback( bool bDeep  )
{
#ifndef QT_ONLY
    m_config->rollback(bDeep);
#else
    Q_UNUSED(bDeep);
#endif 
}

void Config::sync()
{
    m_config->sync();
}

bool Config::hasKey( const TQString& key ) const
{
#ifndef QT_ONLY
    return m_config->hasKey(key);
#else
      return false;
#endif 
}

bool Config::entryIsImmutable(const TQString &key) const
{
#ifndef QT_ONLY
    return m_config->entryIsImmutable(key);
#else
    Q_UNUSED( key );
    return false; 
#endif
}

void Config::revertToDefault(const TQString &key)
{
#ifndef QT_ONLY
    m_config->revertToDefault(key);
#else
    Q_UNUSED(key);
#endif 
}

bool Config::hasDefault(const TQString &key) const
{
#ifndef QT_ONLY
    return m_config->hasDefault(key);
#else
    Q_UNUSED(key);
   return false;
#endif 
}

void Config::setFileWriteMode(int mode)
{
#ifndef QT_ONLY
    m_config->setFileWriteMode(mode);
#else
    Q_UNUSED(mode);
#endif  
}

TQString Config::readEntry(const TQString& pKey, const TQString& aDefault ) const
{
    return m_config->readEntry(pKey,aDefault);
}

TQVariant Config::readPropertyEntry( const TQString& pKey, const TQVariant &pDefault) const
{
#ifndef QT_ONLY
  return m_config->readPropertyEntry(pKey,pDefault);
#else
  TQVariant returnVariant;
  returnVariant = m_config->readEntry(pKey, pDefault.toString());
  return returnVariant;
#endif 
}

TQStringList Config::readListEntry( const TQString& pKey  ) const
{
    return m_config->readListEntry(pKey);
}

TQString Config::readPathEntry( const TQString& pKey, const TQString & aDefault ) const
{
#ifndef QT_ONLY
    return m_config->readPathEntry(pKey,aDefault);
#else
    return readEntry(pKey,aDefault);
#endif 
}

TQStringList Config::readPathListEntry( const TQString& pKey  ) const
{
#ifndef QT_ONLY
    return m_config->readPathListEntry(pKey);
#else
    return readListEntry(pKey);
#endif 
 
}

int Config::readNumEntry( const TQString& pKey, int nDefault) const
{
    return m_config->readNumEntry(pKey,nDefault);
}

uint Config::readUnsignedNumEntry( const TQString& pKey, uint nDefault) const
{
#ifndef QT_ONLY
    return m_config->readUnsignedNumEntry(pKey,nDefault);
#else
    return (uint)readNumEntry(pKey,nDefault);
#endif 
}

long Config::readLongNumEntry( const TQString& pKey, long nDefault) const
{
#ifndef QT_ONLY
    return m_config->readLongNumEntry(pKey,nDefault);
#else
    return (long)readNumEntry(pKey,nDefault);
#endif 
}

double Config::readDoubleNumEntry( const TQString& pKey, double nDefault ) const
{
#ifndef QT_ONLY
    return m_config->readDoubleNumEntry(pKey,nDefault);
#else
    return m_config->readDoubleEntry(pKey,nDefault);
#endif 
}

TQFont Config::readFontEntry( const TQString& pKey, const TQFont* pDefault ) const
{
#ifndef QT_ONLY
    return m_config->readFontEntry(pKey,pDefault);
#else
    return readPropertyEntry(pKey,TQVariant(*pDefault)).toFont();
#endif 
}

bool Config::readBoolEntry( const TQString& pKey, const bool bDefault ) const
{
    return m_config->readBoolEntry(pKey,bDefault);
}

TQRect Config::readRectEntry( const TQString& pKey, const TQRect* pDefault ) const
{
#ifndef QT_ONLY
  return m_config->readRectEntry(pKey,pDefault);
#else
    return readPropertyEntry(pKey,TQVariant(*pDefault)).toRect();
#endif 
}

TQPoint Config::readPointEntry( const TQString& pKey, const TQPoint* pDefault ) const
{
#ifndef QT_ONLY
    return m_config->readPointEntry(pKey,pDefault);
#else
    return readPropertyEntry(pKey,TQVariant(*pDefault)).toPoint();
#endif 
}

TQSize Config::readSizeEntry( const TQString& pKey, const TQSize* pDefault  ) const
{
#ifndef QT_ONLY
    return m_config->readSizeEntry(pKey,pDefault);
#else
    return readPropertyEntry(pKey,TQVariant(*pDefault)).toSize();
#endif 
}

TQColor Config::readColorEntry( const TQString& pKey, const TQColor* pDefault ) const
{
#ifndef QT_ONLY
    return m_config->readColorEntry(pKey,pDefault);
#else
    return readPropertyEntry(pKey,TQVariant(*pDefault)).toColor();
#endif 
}

TQDateTime Config::readDateTimeEntry( const TQString& pKey, const TQDateTime* pDefault) const
{
#ifndef QT_ONLY
    return m_config->readDateTimeEntry(pKey,pDefault);
#else
    return readPropertyEntry(pKey,TQVariant(*pDefault)).toDateTime();
#endif 
}

TQString Config::readEntryUntranslated( const TQString& pKey, const TQString& aDefault ) const
{
#ifndef QT_ONLY
    return m_config->readEntryUntranslated(pKey,aDefault);
#else
    return m_config->readEntry(pKey,aDefault);
#endif
}
void Config::writeEntry( const TQString& pKey, const TQString& pValue  )
{
    m_config->writeEntry(pKey,pValue);
}

void Config::writePropertyEntry( const TQString& pKey, const TQVariant& pValue  )
{
#ifndef QT_ONLY
    m_config->writeEntry(pKey, pValue   );
#else
    m_config->writeEntry(pKey,pValue.toString());
#endif 
}

void Config::writeListEntry( const TQString& pKey, const TQStringList &rValue   )
{
#ifndef QT_ONLY
    m_config->writeEntry(pKey, rValue   );
#else
    m_config->writeEntry(pKey,rValue);
#endif 
}

void Config::writeNumEntry( const TQString& pKey, int nValue  )
{
#ifndef QT_ONLY
    m_config->writeEntry(pKey, nValue  );
#else 
       m_config->writeEntry(pKey,nValue); 
#endif
}
void Config::writeUnsignedNumEntry( const TQString& pKey, uint nValue  )
{
#ifndef QT_ONLY
    m_config->writeEntry(pKey, nValue   );
#else
    writeNumEntry(pKey, (int)nValue );
#endif 
}
void Config::writeLongNumEntry( const TQString& pKey, unsigned long nValue  )
{
#ifndef QT_ONLY
    m_config->writeEntry(pKey, nValue   );
#else
    writeNumEntry(pKey, (int)nValue);
#endif
}
void Config::writeDoubleNumEntry( const TQString& pKey, double nValue )
{
    m_config->writeEntry(pKey,nValue);
}
void Config::writeBoolEntry( const TQString& pKey, bool bValue  )
{
    m_config->writeEntry(pKey,bValue);
}
void Config::writeFontEntry( const TQString& pKey, const TQFont& rFont  )
{
#ifndef QT_ONLY
    m_config->writeEntry(pKey, rFont   );
#else
    writePropertyEntry(pKey,rFont);
#endif 
 
}
void Config::writeColorEntry( const TQString& pKey, const TQColor& rColor  )
{
#ifndef QT_ONLY
    m_config->writeEntry(pKey, rColor   );
#else
    writePropertyEntry(pKey,rColor);
#endif 
 
}
void Config::writeDateTimeEntry( const TQString& pKey, const TQDateTime& rDateTime  )
{
#ifndef QT_ONLY
    m_config->writeEntry(pKey, rDateTime   );
#else
    writePropertyEntry(pKey,rDateTime);
#endif 
 
}
void Config::writeRectEntry( const TQString& pKey, const TQRect& rValue  )
{
#ifndef QT_ONLY
    m_config->writeEntry(pKey, rValue   );
#else
    writePropertyEntry(pKey,rValue);
#endif 
 
}
void Config::writePointEntry( const TQString& pKey, const TQPoint& rValue  )
{
#ifndef QT_ONLY
    m_config->writeEntry(pKey, rValue   );
#else
    writePropertyEntry(pKey,rValue);
#endif 
 
}
void Config::writeSizeEntry( const TQString& pKey, const TQSize& rValue  )
{
#ifndef QT_ONLY
    m_config->writeEntry(pKey, rValue    );
#else
    writePropertyEntry(pKey,rValue);
#endif 
}
void Config::writePathEntry( const TQString& pKey, const TQString & path  )
{
#ifndef QT_ONLY
    m_config->writePathEntry(pKey,path);
#else
    writeEntry(pKey,path);
#endif
}
void Config::writePathListEntry( const TQString& pKey, const TQStringList &rValue   )
{
#ifndef QT_ONLY
    m_config->writePathEntry(pKey,rValue);
#else
    writeListEntry(pKey,rValue);
#endif 
}
void Config::deleteEntry( const TQString& pKey, bool bNLS , bool bGlobal )
{
#ifndef QT_ONLY
    m_config->deleteEntry(pKey,bNLS,bGlobal);
#else
    Q_UNUSED(bNLS);
    Q_UNUSED(bGlobal);
    m_config->removeEntry(pKey);
#endif 
}
bool Config::deleteGroup( const TQString& group, bool bDeep  , bool bGlobal  )
{
#ifndef QT_ONLY
    return m_config->deleteGroup(group,bDeep,bGlobal);
#else
    return false;
#endif
}

}
}
