/***************************************************************************
                          KDEJavaSlot.h  -  description
                             -------------------
    begin                : Tue Oct 31 2000
    copyright            : (C) 2000-2001 by Richard Dale
    email                : Richard_Dale@tipitina.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _KDEJAVASLOT_H_
#define _KDEJAVASLOT_H_

#include <jni.h>
#include <tqobject.h>
#include <qtjava/JavaSlot.h>

#include <dom/dom_node.h>
#include <kxmlguiclient.h>
#include <kspell.h>
#include <kurlrequester.h>
#include <ktoolbar.h>
#include <kaction.h>
#include <kcompletion.h>
#include <kdockwidget.h>
#include <kdualcolorbtn.h>
#include <kfileview.h>
#include <kglobalsettings.h>
#include <klistview.h>
#include <kprocio.h>
#include <kprocess.h>
#include <kparts/part.h>
#include <kparts/browserextension.h>
#include <kio/slave.h>
#include <kio/skipdlg.h>
#include <kbookmark.h>
#include <kdatatool.h>
#include <kfiletreeviewitem.h>
#include <kmdichildfrm.h>

class KDEJavaSlotFactory;

class KDEJavaSlot: public JavaSlot
{
    Q_OBJECT
public:
    KDEJavaSlot(JNIEnv * env, jobject receiver, jstring slot);
    virtual ~KDEJavaSlot();

	/** Converts a Java type signature for a signal to the corresponding C++ Qt type signature */
	virtual const char * javaToQtSignalType(const char * signalName, const char * javaTypeSignature, TQMetaObject * smeta);
	
	/** Converts a Java type signature for a slot to the corresponding C++ Qt type signature */
	virtual const char * javaToQtSlotType(const char * javaTypeSignature, const char * signalString);

public slots:
	void invoke(const DOM::Node& arg1);
	void invoke(const DOM::Node& arg1,long arg2);
	void invoke(const KBookmark& arg1,TQPopupMenu* arg2);
	void invoke(const KDataToolInfo& arg1,const TQString& arg2);
	void invoke(const KFileItem* arg1);
	void invoke(const KFileItem* arg1,const TQPixmap&);
	void invoke(const KFileItem* arg1,const TQPoint&);
	void invoke(const KFileItemList& arg1);
	void invoke(const KFileItem* arg1,TQDropEvent* arg2,const KURL::List& arg3);
	void invoke(const KShortcut& arg1);
	void invoke(const KURL& arg1);
	void invoke(const KURL& arg1,const KURL& arg2);
	void invoke(const KURL& arg1,const TQPixmap& arg2);
	void invoke(const KURL& arg1,const TQString& arg2);
	void invoke(const KURL& arg1, const KParts::URLArgs &arg2);
	void invoke(const KURL::List& arg1);
	void invoke(const TQPoint& arg1,const KFileItemList& arg2);
	void invoke(const TQPoint& arg1,const KURL& arg2,const TQString& arg3);
	void invoke(const TQPoint& arg1,const KURL& arg2,const TQString& arg3,mode_t arg4);
	void invoke(KAction* arg1);
	void invoke(KAction* arg1,bool arg2);
	void invoke(KCompletionBase::KeyBindingType arg1);
	void invoke(KDockWidget* arg1);
	void invoke(KDockWidget*arg1,KDockWidget*arg2);
	void invoke(KDockWidget*arg1,KDockWidget::DockPosition arg2);
	void invoke(KDualColorButton::DualColor arg1);
	void invoke(KFileItem* arg1);
	void invoke(KFileTreeViewItem* arg1);
	void invoke(KFileTreeViewItem* arg1,int arg2);
	void invoke(KFileTreeView* arg1,TQDropEvent* arg2,TQListViewItem* arg3);
	void invoke(KFileTreeView* arg1,TQDropEvent* arg2,TQListViewItem* arg3,TQListViewItem* arg4);
	void invoke(KFileView* arg1);
	void invoke(KGlobalSettings::Completion arg1);
	void invoke(KIO::Job* arg1);
	void invoke(KIO::Job* arg1,const KURL& arg2);
	void invoke(KIO::Job* arg1,const KURL& arg2,const KURL& arg3);
	void invoke(KIO::Job* arg1,const KURL& arg2,const KURL& arg3,bool arg4,bool arg5);
	void invoke(KIO::Job* arg1,const KURL& arg2,const TQString& arg3,const KURL& arg4);
	void invoke(KIO::Job* arg1,const TQByteArray& arg2);
	void invoke(KIO::Job* arg1,const TQString& arg2);
	void invoke(KIO::Job* arg1,const TQString& arg2,const KURL& arg3);
	void invoke(KIO::Job* arg1,KIO::filesize_t arg2);
	void invoke(KIO::Job* arg1,TQByteArray& arg2);
	void invoke(KIO::Job* arg1,unsigned long arg2);
	void invoke(KIO::Slave* arg1);
	void invoke(KIO::SkipDlg* arg1,int arg2);
	void invoke(KIO::Slave*,int arg2,const TQString& arg3);
	void invoke(KListView*arg1,TQDropEvent*arg2,TQListViewItem*arg3);
	void invoke(KListView*arg1,TQDropEvent*arg2,TQListViewItem*arg3,TQListViewItem*arg4);
	void invoke(KListView*arg1,TQListViewItem*arg2);
	void invoke(KListView*arg1,TQListViewItem*arg2,const TQPoint&arg3);
	void invoke(KMdiChildFrm* arg1);
	void invoke(KMdiChildFrm* arg1,KMdiChildFrm* arg2);
	void invoke(KMdiChildView* arg1);
	void invoke(KMdiChildView* arg1,bool arg2);
	void invoke(KMdi::MdiMode arg1);
	void invoke(KParts::Part* arg1);
	void invoke(KPopupMenu* arg1,const TQDate& arg2);
	void invoke(KPopupMenu* arg1,int arg2,TQPopupMenu* arg3);
	void invoke(KProcess* arg1);
	void invoke(KProcess* arg1,char* arg2, int arg3);
	void invoke(KProcIO* arg1);
	void invoke(KSpell* arg1);
	void invoke(KToolBar::BarPosition arg1);
	void invoke(KURL::List& arg1,KURL& arg2);
	void invoke(KURLRequester* arg1);
	void invoke(KXMLGUIClient* arg1);
	void invoke(KXMLGUIClient* arg1,const TQPoint& arg2,const KFileItemList& arg3);
	void invoke(KXMLGUIClient* arg1,const TQPoint& arg2,const KURL& arg3,const TQString& arg4);
	void invoke(KXMLGUIClient* arg1,const TQPoint& arg2,const KURL& arg3,const TQString& arg4,mode_t arg5);
	void invoke(pid_t arg1,const TQCString& arg2,const TQString& arg3,bool arg4);
	void invoke(TQDropEvent* arg1,const KURL::List& arg2,const KURL& arg3);
	void invoke(TQDropEvent* arg1,KFileItem* arg2);
	void invoke(TQWidget* arg1,TQDropEvent* arg2,KURL::List& arg3);
	void invoke(TQWidget* arg1,TQDropEvent* arg2,KURL::List& arg3,KURL&);
};

class KDEJavaSlotFactory : public JavaSlotFactory {
public:
	KDEJavaSlotFactory();
	virtual ~KDEJavaSlotFactory() {};
	virtual JavaSlot *	createJavaSlot(JNIEnv * env, jobject receiver, jstring slot);
};

#endif




