#include <kmime_mdn.h>
using namespace KMime::MDN;

#include <tqcstring.h>
#include <tqstring.h>
#include <tqvaluelist.h>

#include <iostream>
using std::cout;
using std::cerr;
#include <cstdlib>
using std::exit;
using std::endl;

#define _GNU_SOURCE 1
#include <getopt.h>

void usage( const char * msg=0 ) {
  if ( msg )
    cerr << msg << endl;
  cerr << "usage: test_mdn <options>\n"
    "where options include the following:" << endl
       << "FIXME" << endl;
  exit( 1 );
}

int main( int argc, char * argv[] ) {

  TQString finalRecipient;
  TQString originalRecipient;
  TQCString originalMessageId;
  ActionMode actionMode = ManualAction;
  SendingMode sendingMode = SentManually;
  DispositionType dispositionType = Displayed;
  TQValueList<DispositionModifier> dispositionModifiers;
  TQString special;

  while ( true ) {
    int option_index = 0;
    static const struct option long_options[] = {
      { "action-mode", 1, 0, 'a' },
      { "disposition-type", 1, 0, 'd' },
      { "final-recipient", 1, 0, 'f' },
      { "original-message-id", 1, 0, 'i' },
      { "disposition-modifiers", 1, 0, 'm' },
      { "original-recipient", 1, 0, 'o' },
      { "sending-mode", 1, 0, 's' },
      { 0, 0, 0, 0 }
    };

    int c = getopt_long( argc, argv, "a:d:f:i:m:o:s:",
			 long_options, &option_index );
    if ( c == -1 ) break;

#define ETQUALS(x) !qstricmp( optarg, x )

    switch ( c ) {

    case 'a': // --action-mode
      if ( ETQUALS( "manual-action" ) )
	actionMode = ManualAction;
      else if ( ETQUALS( "automatic-action" ) )
	actionMode = AutomaticAction;
      else
	usage( "unknown action mode!" );
      break;

    case 'd': // --disposition-type
      if ( ETQUALS( "displayed" ) )
	dispositionType = Displayed;
      else if ( ETQUALS( "deleted" ) )
	dispositionType = Deleted;
      else if ( ETQUALS( "dispatched" ) )
	dispositionType = Dispatched;
      else if ( ETQUALS( "processed" ) )
	dispositionType = Processed;
      else if ( ETQUALS( "denied" ) )
	dispositionType = Denied;
      else if ( ETQUALS( "failed" ) )
	dispositionType = Failed;
      else
	usage( "unknown disposition type!" );
      break;

    case 'f': // --final-recipient
      if ( optarg && *optarg )
	finalRecipient = TQString::fromUtf8( optarg );
      else
	usage( "--final-recipient is missing a value" );
      break;

    case 'i': // --original-message-id
      if ( optarg && *optarg )
	originalMessageId = optarg;
      else
	usage( "--original-message-id is missing a value" );
      break;

    case 'm': // --disposition-modifier
      if ( ETQUALS( "error" ) )
	dispositionModifiers << Error;
      else if ( ETQUALS( "warning" ) )
	dispositionModifiers << Warning;
      else if ( ETQUALS( "superseded" ) )
	dispositionModifiers << Superseded;
      else if ( ETQUALS( "expired" ) )
	dispositionModifiers << Expired;
      else if ( ETQUALS( "mailbox-terminated" ) )
	dispositionModifiers << MailboxTerminated;
      else
	usage( "unknwon disposition modifier!" );
      break;

    case 'o': // --original-recipient
      if ( optarg && *optarg )
	originalRecipient = TQString::fromUtf8( optarg );
      else
	usage( "--original-recipient is missing a value" );
      break;

    case 's': // --sending-mode
      if ( ETQUALS( "MDN-sent-manually" ) )
	sendingMode = SentManually;
      else if ( ETQUALS( "MDN-sent-automatically" ) )
	sendingMode = SentAutomatically;
      else
	usage( "unknown sending mode" );
      break;

    default:
      usage( "unknown option encountered!" );
    }
  }

  if ( optind < argc )
    special = TQString::fromUtf8( argv[optind++] );
  if ( optind < argc )
    usage( "too many arguments!" );

  TQCString result = dispositionNotificationBodyContent( finalRecipient,
						       originalRecipient.latin1(),
						       originalMessageId,
						       dispositionType,
						       actionMode,
						       sendingMode,
						       dispositionModifiers,
						       special );
  cout << "Result:\n" << result.data();

  return 0;
}
