/*  -*- mode: C++; c-file-style: "gnu" -*-
 *
 *  This file is part of KMail, the KDE mail client.
 *
 *  Copyright (c) 2003 Zack Rusin <zack@kde.org>
 *
 *  KMail is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License, version 2, as
 *  published by the Free Software Foundation.
 *
 *  KMail is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of this program with any edition of
 *  the TQt library by Trolltech AS, Norway (or with modified versions
 *  of TQt that use the same license as TQt), and distribute linked
 *  combinations including the two.  You must obey the GNU General
 *  Public License in all respects for all of the code used other than
 *  TQt.  If you modify this file, you may extend this exception to
 *  your version of the file, but you are not obligated to do so.  If
 *  you do not wish to do so, delete this exception statement from
 *  your version.
 */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "ssllabel.h"

#include <kiconloader.h>
#include <klocale.h>

#include <tqtooltip.h>

namespace KPIM {

SSLLabel::SSLLabel( TQWidget* parent )
  : TQLabel( parent )
{
  setState( Done );
}

void SSLLabel::setEncrypted( bool enc )
{
  if ( enc ) {
    m_lastEncryptionState = Encrypted;
  } else {
    m_lastEncryptionState = Unencrypted;
  }
}

SSLLabel::State SSLLabel::lastState() const
{
  return m_lastEncryptionState;
}

void SSLLabel::setState( State state )
{
  switch( state ) {
  case Encrypted:
    TQToolTip::remove( this );
    TQToolTip::add( this, i18n("Connection is encrypted") );
    setPixmap( SmallIcon( "encrypted", KGlobal::instance() ) );
    show();
    break;
  case Unencrypted:
    TQToolTip::remove( this );
    TQToolTip::add( this, i18n("Connection is unencrypted") );
    setPixmap( SmallIcon( "decrypted" ) );
    show();
    break;
  case Done:
    TQToolTip::remove( this );
    hide();
    break;
  case Clean:
  default:
    TQToolTip::remove( this );
    hide();
    //we return because we do not save the state as the only
    //action we want to perform is to hide ourself
    return;
  }
  m_lastEncryptionState = state;
}


} //end namespace KPIM

//#include "ssllabel.moc"
