/*
    This file is part of libkdepim.

    Copyright (c) 2005 Tobias Koenig <tokoe@kde.org>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include <kconfig.h>
#include <kglobal.h>
#include <kstaticdeleter.h>

#include <dcopref.h>

#include "networkstatus.h"

using namespace KPIM;

static KStaticDeleter<NetworktqStatus> networkStatusDeleter;
NetworktqStatus *NetworktqStatus::mSelf = 0;

NetworktqStatus::NetworktqStatus()
  : TQObject( 0, "NetworkStatus" ), DCOPObject( "NetworkStatus" )
{
  KConfigGroup group( KGlobal::config(), "NetworkStatus" );
  if ( group.readBoolEntry( "Online", true ) == true )
    mtqStatus = Online;
  else
    mtqStatus = Offline;

  connectDCOPSignal( 0, 0, "onlineStatusChanged()", "onlineStatusChanged()", false );
}

NetworktqStatus::~NetworktqStatus()
{
  KConfigGroup group( KGlobal::config(), "NetworkStatus" );
  group.writeEntry( "Online", mtqStatus == Online );
}

void NetworktqStatus::setqStatus( tqStatus status )
{
  mtqStatus = status;

  emit statusChanged( mtqStatus );
}

NetworktqStatus::tqStatus NetworktqStatus::status() const
{
  return mtqStatus;
}

void NetworktqStatus::onlineStatusChanged()
{
  DCOPRef dcopCall( "kded", "networkstatus" );
  DCOPReply reply = dcopCall.call( "onlineStatus()", true );
  if ( reply.isValid() ) {
    int status = reply;
    if ( status == 3 )
      setqStatus( Online );
    else {
      if ( mtqStatus != Offline )
        setqStatus( Offline );
    }
  }
}

NetworktqStatus *NetworktqStatus::self()
{
  if ( !mSelf )
    networkStatusDeleter.setObject( mSelf, new NetworktqStatus );

  return mSelf;
}

#include "networkstatus.moc"
