/*
    This file is part of KOrganizer.

    Copyright (c) 2003 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/
#ifndef ALARMDOCKWINDOW_H
#define ALARMDOCKWINDOW_H

#include <ksystemtray.h>

#include <tqpixmap.h>

class AlarmDockWindow : public KSystemTray
{
    Q_OBJECT
  TQ_OBJECT
  public:
    AlarmDockWindow( const char *name = 0 );
    virtual ~AlarmDockWindow();

    void enableAutostart( bool enabled );

  public slots:
    void toggleAlarmsEnabled();
    void toggleAutostart();
    void slotUpdate( int reminders );

  signals:
    void quitSignal();
    void suspendAllSignal();
    void dismissAllSignal();

  protected:
    void mousePressEvent( TQMouseEvent * );
//    void closeEvent( TQCloseEvent * );
    void resizeEvent ( TQResizeEvent * );

  protected slots:
    void slotQuit();
    void slotSuspendAll();
    void slotDismissAll();

  private:
    TQPixmap mPixmapEnabled;
    TQPixmap mPixmapDisabled;
    TQString mName;

    int mAlarmsEnabledId;
    int mAutostartId;
    int mSuspendAll;
    int mDismissAll;
};

#endif
