/*
    This file is part of KOrganizer.

    Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#include <ksimpleconfig.h>
#include <kstandarddirs.h>
#include <kdebug.h>

#include "docprefs.h"

KSimpleConfig *DocPrefs::mConfig = 0;

DocPrefs::DocPrefs( const TQString &type )
{
    if ( !mConfig ) {
        mConfig = new KSimpleConfig( locateLocal( "data", "korganizer/docprefs." + type + ".kconfig" ) );
    }
}

DocPrefs::~DocPrefs()
{
    mConfig->sync();
}

void DocPrefs::setDoc( const TQString &identifier )
{
    mDocId = identifier;
}

TQString DocPrefs::doc() const
{
    return mDocId;
}

bool DocPrefs::readBoolEntry( const TQString &id ) const
{
    mConfig->setGroup( mDocId );
    bool result = mConfig->readBoolEntry( id, false );
//    kdDebug(5850) << "DocPrefs::readEntry(): " << id << " : " << (result ? "True" : "False" ) << endl;
    return result;
}

void DocPrefs::writeEntry( const TQString &id, bool value )
{
//    kdDebug(5850) << "DocPrefs::writeEntry(): " << id << " : " << (value ? "True" : "False" ) << endl;
    mConfig->setGroup( mDocId );
    mConfig->writeEntry( id, value );
}
