/*
    This file is part of KDE Kontact.

    Copyright (c) 2004 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef KCMKONTACTSUMMARY_H
#define KCMKONTACTSUMMARY_H

#include <kcmodule.h>
#include <klistview.h>

class KPluginInfo;

class PluginView : public KListView
{
  Q_OBJECT
  TQ_OBJECT

  public:
    PluginView( TQWidget *parent, const char *name = 0 );
    ~PluginView();
};

class KCMKontactSummary : public KCModule
{
  Q_OBJECT
  TQ_OBJECT

  public:
    KCMKontactSummary( TQWidget *parent = 0, const char *name = 0 );

    virtual void load();
    virtual void save();
    virtual void defaults();

  private slots:
    void itemClicked( TQListViewItem* );

  private:
    PluginView *mPluginView;

    KPluginInfo::List mPluginList;
};

#endif
