/*
    This file is part of Kontact.
    Copyright (c) 2004 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef NEWSFEEDS_H
#define NEWSFEEDS_H

#include <tqvaluelist.h>

#define DEFAULT_NEWSSOURCES 60

class NewsSourceData
{
  public:
    typedef TQValueList<NewsSourceData> List;

    enum Category { Arts, Business, Computers, Misc,
                    Recreation, Society };

    NewsSourceData( const TQString &name = I18N_NOOP( "Unknown" ),
                    const TQString &url = TQString(),
                    const TQString &icon = TQString(),
                    const Category category= Computers )
      : mName( name ), mURL( url ), mIcon( icon ), mCategory( category )
    {
    }

    TQString name() const { return mName; }
    TQString url() const { return mURL; }
    TQString icon() const { return mIcon; }
    Category category() const { return mCategory; }

    TQString mName;
    TQString mURL;
    TQString mIcon;
    Category mCategory;
};

static NewsSourceData NewsSourceDefault[DEFAULT_NEWSSOURCES] = {
  // Arts ---------------
    NewsSourceData(
    TQString::tqfromLatin1("Bureau 42"),
    TQString::tqfromLatin1("http://www.bureau42.com/rdf/"),
    TQString::tqfromLatin1("http://www.bureau42.com/favicon.ico"),
    NewsSourceData::Arts ),
    NewsSourceData(
    TQString::tqfromLatin1("eFilmCritic"),
    TQString::tqfromLatin1("http://efilmcritic.com/fo.rdf"),
    TQString::tqfromLatin1("http://efilmcritic.com/favicon.ico"),
    NewsSourceData::Arts ),
  // Business -----------
    NewsSourceData(
    TQString::tqfromLatin1("Internet.com Business"),
    TQString::tqfromLatin1("http://headlines.internet.com/internetnews/bus-news/news.rss"),
    TQString(),
    NewsSourceData::Business ),
    NewsSourceData(
    TQString::tqfromLatin1("TradeSims"),
    TQString::tqfromLatin1("http://www.tradesims.com/AEX.rdf"),
    TQString(),
    NewsSourceData::Business ),
  // Computers ----------
    NewsSourceData(
    TQString::tqfromLatin1("KDE Deutschland"),
    TQString::tqfromLatin1("http://www.kde.de/nachrichten/nachrichten.rdf"),
    TQString::tqfromLatin1("http://www.kde.de/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("KDE France"),
    TQString::tqfromLatin1("http://www.kde-france.org/backend-breves.php3"),
    TQString(),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("FreeBSD Project News"),
    TQString::tqfromLatin1("http://www.freebsd.org/news/news.rdf"),
    TQString::tqfromLatin1("http://www.freebsd.org/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("dot.kde.org"),
    TQString::tqfromLatin1("http://www.kde.org/dotkdeorg.rdf"),
    TQString::tqfromLatin1("http://www.kde.org/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData( TQString::tqfromLatin1("KDE-Look.org"),
                    TQString::tqfromLatin1("http://www.kde.org/kde-look-content.rdf"),
                    TQString::tqfromLatin1("http://kde-look.org/img/favicon-1-1.ico"),
                    NewsSourceData::Computers ),
    NewsSourceData( TQString::tqfromLatin1("KDE-Apps.org"),
                    TQString::tqfromLatin1("http://www.kde.org/dot/kde-apps-content.rdf"),
                    TQString::tqfromLatin1("http://kde-apps.org/img/favicon-1-1.ico"),
                    NewsSourceData::Computers ),
    NewsSourceData( TQString::tqfromLatin1("DesktopLinux"),
                    TQString::tqfromLatin1("http://www.desktoplinux.com/backend/index.html"),
                    TQString::tqfromLatin1("http://www.desktoplinux.com/images/favicon.ico"),
                    NewsSourceData::Computers ),
    NewsSourceData( TQString::tqfromLatin1("DistroWatch"),
                    TQString::tqfromLatin1("http://distrowatch.com/news/dw.xml"),
                    TQString::tqfromLatin1("http://distrowatch.com/favicon.ico"),
                    NewsSourceData::Computers ),
    /*URL changed*/
    NewsSourceData(
    TQString::tqfromLatin1("GNOME News"),
    TQString::tqfromLatin1("http://www.gnomedesktop.org/node/feed"),
    TQString(),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("Slashdot"),
    TQString::tqfromLatin1("http://slashdot.org/slashdot.rdf"),
    TQString::tqfromLatin1("http://slashdot.org/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("Ask Slashdot"),
    TQString::tqfromLatin1("http://slashdot.org/askslashdot.rdf"),
    TQString::tqfromLatin1("http://slashdot.org/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("Slashdot: Features"),
    TQString::tqfromLatin1("http://slashdot.org/features.rdf"),
    TQString::tqfromLatin1("http://slashdot.org/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("Slashdot: Apache"),
    TQString::tqfromLatin1("http://slashdot.org/apache.rdf"),
    TQString::tqfromLatin1("http://slashdot.org/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("Slashdot: Books"),
    TQString::tqfromLatin1("http://slashdot.org/books.rdf"),
    TQString::tqfromLatin1("http://slashdot.org/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("Jabber News"),
    TQString::tqfromLatin1("http://www.jabber.org/news/rss.xml"),
    TQString(),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("Freshmeat"),
    TQString::tqfromLatin1("http://freshmeat.net/backend/fm.rdf"),
    TQString::tqfromLatin1("http://freshmeat.net/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("Linux Weekly News"),
    TQString::tqfromLatin1("http://www.lwn.net/headlines/rss"),
    TQString::tqfromLatin1("http://www.lwn.net/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("heise online news"),
    TQString::tqfromLatin1("http://www.heise.de/newsticker/heise.rdf"),
    TQString::tqfromLatin1("http://www.heise.de/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("RUS-CERT Ticker"),
    TQString::tqfromLatin1("http://cert.uni-stuttgart.de/ticker/rus-cert.rdf"),
    TQString::tqfromLatin1("http://cert.uni-stuttgart.de/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("RUS-CERT Elsewhere"),
    TQString::tqfromLatin1("http://cert.uni-stuttgart.de/ticker/rus-cert-elsewhere.rdf"),
    TQString::tqfromLatin1("http://cert.uni-stuttgart.de/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("Kuro5hin"),
    TQString::tqfromLatin1("http://kuro5hin.org/backend.rdf"),
    TQString::tqfromLatin1("http://kuro5hin.org/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("Prolinux"),
    TQString::tqfromLatin1("http://www.pl-forum.de/backend/pro-linux.rdf"),
    TQString::tqfromLatin1("http://www.prolinux.de/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("LinuxSecurity.com"),
    TQString::tqfromLatin1("http://www.linuxsecurity.com/linuxsecurity_hybrid.rdf"),
    TQString::tqfromLatin1("http://www.linuxsecurity.com/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("Linux Game Tome"),
    TQString::tqfromLatin1("http://happypenguin.org/html/news.rdf"),
    TQString(),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("Mozilla"),
    TQString::tqfromLatin1("http://www.mozilla.org/news.rdf"),
    TQString::tqfromLatin1("http://www.mozillazine.org/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("MozillaZine"),
    TQString::tqfromLatin1("http://www.mozillazine.org/contents.rdf"),
    TQString::tqfromLatin1("http://www.mozillazine.org/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("Daemon News"),
    TQString::tqfromLatin1("http://daily.daemonnews.org/ddn.rdf.php3"),
    TQString(),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("use Perl;"),
    TQString::tqfromLatin1("http://use.perl.org/useperl.rdf"),
    TQString(),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("Root prompt"),
    TQString::tqfromLatin1("http://www.rootprompt.org/rss/"),
    TQString::tqfromLatin1("http://www.rootprompt.org/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("SecurityFocus"),
    TQString::tqfromLatin1("http://www.securityfocus.com/topnews-rdf.html"),
    TQString::tqfromLatin1("http://www.securityfocus.com/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("Arstechnica"),
    TQString::tqfromLatin1("http://arstechnica.com/etc/rdf/ars.rdf"),
    TQString::tqfromLatin1("http://arstechnica.com/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("amiga-news.de - deutschsprachige Amiga Nachrichten"),
    TQString::tqfromLatin1("http://www.amiga-news.de/de/backends/news/index.rss"),
    TQString::tqfromLatin1("http://www.amiga-news.de/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("amiga-news.de - english Amiga news"),
    TQString::tqfromLatin1("http://www.amiga-news.de/en/backends/news/index.rss"),
    TQString::tqfromLatin1("http://www.amiga-news.de/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("FreshPorts - the place for ports"),
    TQString::tqfromLatin1("http://www.freshports.org/news.php3"),
    TQString::tqfromLatin1("http://www.freshports.org/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("zez.org - about code "),
    TQString::tqfromLatin1("http://zez.org/article/rssheadlines"),
    TQString(),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("BSDatwork.com"),
    TQString::tqfromLatin1("http://BSDatwork.com/backend.php"),
    TQString::tqfromLatin1("http://BSDatwork.com/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("FreshSource - the place for source"),
    TQString::tqfromLatin1("http://www.freshsource.org/news.php"),
    TQString::tqfromLatin1("http://www.freshsource.org/favicon.ico"),
    NewsSourceData::Computers ),
    NewsSourceData(
    TQString::tqfromLatin1("The FreeBSD Diary"),
    TQString::tqfromLatin1("http://www.freebsddiary.org/news.php"),
    TQString::tqfromLatin1("http://www.freebsddiary.org/favicon.ico"),
    NewsSourceData::Computers ),
  // Miscellaneous ------
    NewsSourceData(
    TQString::tqfromLatin1("tagesschau.de"),
    TQString::tqfromLatin1("http://www.tagesschau.de/newsticker.rdf"),
    TQString::tqfromLatin1("http://www.tagesschau.de/favicon.ico"),
    NewsSourceData::Misc ),
    NewsSourceData(
    TQString::tqfromLatin1("CNN Top Stories"),
    TQString::tqfromLatin1("http://rss.cnn.com/rss/cnn_topstories.rss"),
    TQString::tqfromLatin1("http://www.cnn.com/favicon.ico"),
    NewsSourceData::Misc ),
    /*feed URL changed*/
    NewsSourceData(
    TQString::tqfromLatin1("HotWired"),
    TQString::tqfromLatin1("http://www.wired.com/news/feeds/rss2/0,2610,,00.xml"),
    TQString::tqfromLatin1("http://www.hotwired.com/favicon.ico"),
    NewsSourceData::Misc ),
    NewsSourceData(
    TQString::tqfromLatin1("The Register"),
    TQString::tqfromLatin1("http://www.theregister.co.uk/headlines.rss"),
    TQString::tqfromLatin1("http://www.theregister.co.uk/favicon.ico"),
    NewsSourceData::Misc ),
    NewsSourceData(
    TQString::tqfromLatin1( "Christian Science Monitor" ),
    TQString::tqfromLatin1( "http://www.csmonitor.com/rss/csm.rss"),
    TQString::tqfromLatin1( "http://www.csmonitor.com/favicon.ico"),
    NewsSourceData::Misc ),
  // Recreation
   // Society
    NewsSourceData(
    TQString::tqfromLatin1("nippon.it"),
    TQString::tqfromLatin1("http://www.nippon.it/backend.it.php"),
    TQString::tqfromLatin1("http://www.nippon.it/favicon.ico"),
    NewsSourceData::Society ),
    NewsSourceData(
    TQString::tqfromLatin1( "gflash" ),
    TQString::tqfromLatin1( "http://www.gflash.de/backend.php"),
    TQString::tqfromLatin1( "http://www.gflash.de/favicon.ico"),
    NewsSourceData::Society ),
    NewsSourceData(
    TQString::tqfromLatin1( "Quintessenz" ),
    TQString::tqfromLatin1( "http://quintessenz.at/cgi-bin/rdf"),
    TQString::tqfromLatin1( "http://quintessenz.at/favicon.ico"),
    NewsSourceData::Society )
};

#endif
