/*
    This file is part of KDE Kontact.

    Copyright (c) 2001 Matthias Hoelzer-Kluepfel <mhk@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef KORGANIZER_PLUGIN_H
#define KORGANIZER_PLUGIN_H

#include <klocale.h>
#include <kparts/part.h>

#include "kcalendariface_stub.h"
#include "korganizeriface_stub.h"
#include "plugin.h"
#include "uniqueapphandler.h"

class KOrganizerPlugin : public Kontact::Plugin
{
  Q_OBJECT
  TQ_OBJECT

  public:
    KOrganizerPlugin( Kontact::Core *core, const char *name, const TQStringList& );
    ~KOrganizerPlugin();

    virtual bool createDCOPInterface( const TQString& serviceType );
    virtual bool isRunningStandalone();
    int weight() const { return 400; }

    virtual bool queryClose() const;

    bool canDecodeDrag( TQMimeSource * );
    void processDropEvent( TQDropEvent * );

    virtual Kontact::Summary *createSummaryWidget( TQWidget *parent );

    virtual TQString tipFile() const;
    virtual TQStringList invisibleToolbarActions() const;

    void select();

    KCalendarIface_stub *interface();


    void loadProfile( const TQString& path );
    void saveToProfile( const TQString& path ) const;

  protected:
    KParts::ReadOnlyPart *createPart();

  private slots:
    void slotNewEvent();
    void slotSyncEvents();

  private:
    KCalendarIface_stub *mIface;
    Kontact::UniqueAppWatcher *mUniqueAppWatcher;
};

#endif
