/*
    This file is part of Kontact.

    Copyright (c) 2003 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#include <tqwidget.h>

#include <kaboutdata.h>
#include <kaction.h>
#include <kapplication.h>
#include <kdebug.h>
#include <kgenericfactory.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kparts/componentfactory.h>

#include "core.h"
#include "plugin.h"

#include "kitchensync_plugin.h"

typedef KGenericFactory< KitchenSyncPlugin, Kontact::Core > KitchenSyncPluginFactory;
K_EXPORT_COMPONENT_FACTORY( libkontact_kitchensync,
                            KitchenSyncPluginFactory( "kontact_kitchensync" ) )

KitchenSyncPlugin::KitchenSyncPlugin( Kontact::Core *core, const char *, const TQStringList& )
  : Kontact::Plugin( core, TQT_TQOBJECT(core), "KitchenSync" )
{
  setInstance( KitchenSyncPluginFactory::instance() );
}

KitchenSyncPlugin::~KitchenSyncPlugin()
{
}

KParts::ReadOnlyPart* KitchenSyncPlugin::createPart()
{
  return loadPart();
}

TQStringList KitchenSyncPlugin::configModules() const
{
  TQStringList modules;
  modules << "PIM/kitchensync.desktop";
  return modules;
}

#include "kitchensync_plugin.moc"
