/*******************************************************************
 KNotes -- Notes for the KDE project

 Copyright (c) 2005, Michael Brade <brade@kde.org>

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

 In addition, as a special exception, the copyright holders give
 permission to link the code of this program with any edition of
 the TQt library by Trolltech AS, Norway (or with modified versions
 of TQt that use the same license as TQt), and distribute linked
 combinations including the two.  You must obey the GNU General
 Public License in all respects for all of the code used other than
 TQt.  If you modify this file, you may extend this exception to
 your version of the file, but you are not obligated to do so.  If
 you do not wish to do so, delete this exception statement from
 your version.
*******************************************************************/

#include <tqlabel.h>
#include <tqradiobutton.h>
#include <tqbuttongroup.h>
#include <tqvbox.h>

#include <klocale.h>

#include <libkdepim/kdateedit.h>
#include <libkdepim/ktimeedit.h>

#include <libkcal/journal.h>
#include <libkcal/alarm.h>

#include "knotealarmdlg.h"


KNoteAlarmDlg::KNoteAlarmDlg( const TQString& caption, TQWidget *parent, const char *name )
    : KDialogBase( parent, name, true, caption, Ok|Cancel, Ok )
{
    TQVBox *page = makeVBoxMainWidget();
    TQGroupBox *group = new TQGroupBox( 3, Qt::Vertical, i18n("Scheduled Alarm"), page );
    m_buttons = new TQButtonGroup( page );
    m_buttons->hide();

    TQRadioButton *none = new TQRadioButton( i18n("&No alarm"), group );
    m_buttons->insert( none );

    TQHBox *at = new TQHBox( group );
    TQRadioButton *label_at = new TQRadioButton( i18n("Alarm &at:"), at );
    m_buttons->insert( label_at );
    m_atDate = new KDateEdit( at );
    m_atTime = new KTimeEdit( at );
    at->setStretchFactor( m_atDate, 1 );

    TQHBox *in = new TQHBox( group );
    TQRadioButton *label_in = new TQRadioButton( i18n("Alarm &in:"), in );
    m_buttons->insert( label_in );
    m_inTime = new KTimeEdit( in );
    TQLabel *in_min = new TQLabel( i18n("hours/minutes"), in );

    label_in->setEnabled( false ); // TODO
    in->hide(); //show it and enable it when feature will implement
 
    connect( m_buttons, TQT_SIGNAL(clicked( int )), TQT_SLOT(slotButtonChanged( int )) );
}


void KNoteAlarmDlg::setIncidence( KCal::Journal *journal )
{
    m_journal = journal;

    if ( !m_journal->alarms().isEmpty() )
    {
        KCal::Alarm *alarm = m_journal->alarms().first();
        if ( alarm->hasTime() )
        {
            m_buttons->setButton( 1 );
            m_atDate->setDate( alarm->time().date() );
            m_atTime->setTime( alarm->time().time() );
        }
        else if ( alarm->hasStartOffset() )
            m_buttons->setButton( 2 );
        else
            m_buttons->setButton( 0 );
    }
    else
        m_buttons->setButton( 0 );

    slotButtonChanged( m_buttons->selectedId() );
}

void KNoteAlarmDlg::slotButtonChanged( int id )
{
    switch ( id )
    {
    case 0:
        m_atDate->setEnabled( false );
        m_atTime->setEnabled( false );
        m_inTime->setEnabled( false );
        break;
    case 1:
        m_atDate->setEnabled( true );
        m_atTime->setEnabled( true );
        m_inTime->setEnabled( false );
        break;
    case 2:
        m_atDate->setEnabled( false );
        m_atTime->setEnabled( false );
        m_inTime->setEnabled( true );
    }
}

void KNoteAlarmDlg::slotOk()
{
    if ( m_buttons->selectedId() == 0 )
    {
        m_journal->clearAlarms();
        KDialogBase::slotOk();
        return;
    }

    KCal::Alarm *alarm;
    if ( m_journal->alarms().isEmpty() )
    {
        alarm = m_journal->newAlarm();
        alarm->setEnabled( true );
        alarm->setType( KCal::Alarm::Display );
    }
    else
        alarm = m_journal->alarms().first();

    if ( m_buttons->selectedId() == 1 )
        alarm->setTime( TQDateTime( m_atDate->date(), m_atTime->getTime() ) );
    else
    {
        // TODO
    }

    KDialogBase::slotOk();
}

#include "knotealarmdlg.moc"
