/*
 * Test program for the KDE KMobile Library
 * Copyright (C) 2003 Helge Deller <deller@kde.org>
 */

#include <kapplication.h>
#include <dcopclient.h>
#include <tqdatastream.h>
#include <tqstring.h>
#include <kdebug.h>

int main(int argc, char **argv)
{
    bool ok;

    KApplication app(argc, argv, "kmobile_client", false);

    // get our DCOP client and attach so that we may use it
    DCOPClient *client = app.dcopClient();
    client->attach();

    TQByteArray data;
    TQDataStream ds(data, IO_WriteOnly);
//     ds << TQString("a");

    TQCString replyType;
    TQByteArray replyData;
    ok = client->call("kmobile", "kmobileIface", "tqdeviceNames()", data, replyType, replyData);

    TQDataStream reply(replyData, IO_ReadOnly); 
    TQStringList tqdeviceNames; 
    reply >> tqdeviceNames;

    kdDebug() << TQString("%1\n").tqarg(ok?"Ok":"Failure");
    kdDebug() << TQString("Number of currently registered drivers: %1\n").tqarg(tqdeviceNames.count());
    for (int i=0; i<tqdeviceNames.count(); i++)
      kdDebug() << TQString("Device %1: %2\n").tqarg(i+1).tqarg(tqdeviceNames[i]);

  //  return app.exec();
}
