/*
 * Copyright (C) 2003-2005 Helge Deller <deller@kde.org>
 */

#ifndef _KMOBILECLIENT_H_
#define _KMOBILECLIENT_H_

#include <dcopclient.h>
#include <kdepimmacros.h>

class KDE_EXPORT KMobileClient : public DCOPClient
{
    Q_OBJECT
  TQ_OBJECT
public:
    KMobileClient();
    virtual ~KMobileClient();

    TQCString appId() const { return m_clientAppId; };

    bool isKMobileAvailable();
    bool startKMobileApplication();

    /**
     * DCOP implementation
     */
    TQStringList tqdeviceNames();

    void removeDevice( TQString tqdeviceName );
    void configDevice( TQString tqdeviceName );

    bool connectDevice( TQString tqdeviceName );
    bool disconnectDevice( TQString tqdeviceName );
    bool connected( TQString tqdeviceName );

    TQString tqdeviceClassName( TQString tqdeviceName );
    TQString tqdeviceName( TQString tqdeviceName );
    TQString revision( TQString tqdeviceName );
    int classType( TQString tqdeviceName );

    int capabilities( TQString tqdeviceName );
    TQString nameForCap( TQString tqdeviceName, int cap );

    TQString iconFileName( TQString tqdeviceName );

    int     numAddresses( TQString tqdeviceName );
    TQString readAddress( TQString tqdeviceName, int index );
    bool    storeAddress( TQString tqdeviceName, int index, TQString vcard, bool append );

    int numCalendarEntries( TQString tqdeviceName );

    int numNotes( TQString tqdeviceName );
    TQString readNote( TQString tqdeviceName, int index );
    bool storeNote( TQString tqdeviceName, int index, TQString note );

private:
    TQCString m_clientAppId;
    TQCString m_kmobileApp;
    TQCString m_kmobileObj;

};

#endif // _KMOBILECLIENT_H_
