/*
    This file is part of KitchenSync.

    Copyright (c) 2007 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
    USA.
*/

#include "configguigpe.h"

#include <tqcheckbox.h>
#include <tqdom.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqspinbox.h>

#include <kcombobox.h>
#include <kdialog.h>
#include <klineedit.h>
#include <klocale.h>

ConfigGuiGpe::ConfigGuiGpe( const QSync::Member &member, TQWidget *parent )
  : ConfigGui( member, parent )
{
  initGUI();

  mConnectionMode->insertItem( i18n( "Local" ) );
  mConnectionMode->insertItem( i18n( "Ssh" ) );
}

void ConfigGuiGpe::load( const TQString &xml )
{
  TQDomDocument doc;
  doc.setContent( xml );
  TQDomElement docElement = doc.documentElement();
  TQDomNode node;
  for( node = docElement.firstChild(); !node.isNull(); node = node.nextSibling() ) {
    TQDomElement element = node.toElement();
    if ( element.tagName() == "use_local" ) {
      if ( element.text().toInt() == 1 )
        mConnectionMode->setCurrentItem( 0 );
      else
        mConnectionMode->setCurrentItem( 1 );
    } else if ( element.tagName() == "handheld_ip" ) {
      mIP->setText( element.text() );
    } else if ( element.tagName() == "handheld_port" ) {
      mPort->setValue( element.text().toInt() );
    } else if ( element.tagName() == "handheld_user" ) {
      mUser->setText( element.text() );
    }
  }
}

TQString ConfigGuiGpe::save() const
{
  TQString config = "<config>";

  config += TQString( "<use_local>%1</use_local>" ).tqarg( mConnectionMode->currentItem() == 0 );
  config += TQString( "<use_ssh>%1</use_ssh>" ).tqarg( mConnectionMode->currentItem() == 1 );
  config += TQString( "<handheld_ip>%1</handheld_ip>" ).tqarg( mIP->text() );
  config += TQString( "<handheld_port>%1</handheld_port>" ).tqarg( mPort->value() );
  config += TQString( "<handheld_user>%1</handheld_user>" ).tqarg( mUser->text() );

  config += "</config>";

  return config;
}

void ConfigGuiGpe::initGUI()
{
  TQGridLayout *tqlayout = new TQGridLayout( topLayout(), 12, 4, KDialog::spacingHint() );
  tqlayout->setMargin( KDialog::marginHint() );

  tqlayout->addWidget( new TQLabel( i18n( "Connection Mode:" ), this ), 0, 0 );
  mConnectionMode = new KComboBox( this );
  tqlayout->addMultiCellWidget( mConnectionMode, 0, 0, 0, 3 );

  tqlayout->addWidget( new TQLabel( i18n( "IP Address:" ), this ), 1, 0 );
  mIP = new KLineEdit( this );
  mIP->setInputMask( "000.000.000.000" );
  tqlayout->addWidget( mIP, 1, 1 );

  tqlayout->addWidget( new TQLabel( i18n( "Port:" ), this ), 1, 2, TQt::AlignRight );
  mPort = new TQSpinBox( 1, 65536, 1, this );
  tqlayout->addWidget( mPort, 1, 3 );

  tqlayout->addWidget( new TQLabel( i18n( "User:" ), this ), 2, 0 );
  mUser = new KLineEdit( this );
  tqlayout->addMultiCellWidget( mUser, 2, 2, 1, 3 );
}
