/*
    This file is part of Kandy.

    Copyright (c) 2001 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#include <kapplication.h>
#include <dcopclient.h>
#include <tqdatastream.h>
#include <tqstring.h>

int main(int argc, char **argv)
{
    KApplication app(argc, argv, "kandy_client", false);

    // get our DCOP client and attach so that we may use it
    DCOPClient *client = app.dcopClient();
    client->attach();

    // do a 'send' for now
    TQByteArray data;
    TQDataStream ds(data, IO_WriteOnly);
    if (argc > 1)
        ds << TQString(argv[1]);
    else
        ds << TQString("http://www.kde.org");
    client->send("kandy", "KandyIface", "openURL(TQString)", data);

    return app.exec();
}
