/*
    This file is part of KAddressBook.
    Copyright (c) 2002 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef VIEWCONFIGUREFIELDSPAGE_H
#define VIEWCONFIGUREFIELDSPAGE_H

#include <tqwidget.h>

#include <kabc/field.h>
#include <kabc/addressbook.h>

class KComboBox;
class TQListBox;
class TQListBoxItem;
class TQPushButton;
class TQToolButton;

class ViewConfigureFieldsPage : public TQWidget
{
  Q_OBJECT
  TQ_OBJECT

  public:
    ViewConfigureFieldsPage( KABC::AddressBook *ab, TQWidget *parent = 0,
                             const char *name = 0 );

    void restoreSettings( KConfig* );
    void saveSettings( KConfig* );

  public slots:
    void slotSelect();
    void slotUnSelect();
    void slotMoveUp();
    void slotMoveDown();

    void slotShowFields( int );
    void slotButtonsEnabled();

  private:
    void initGUI();

    KComboBox *mCategoryCombo;
    TQListBox *mSelectedBox;
    TQListBox *mUnSelectedBox;
    TQToolButton *mAddButton;
    TQToolButton *mRemoveButton;
    TQToolButton *mUpButton;
    TQToolButton *mDownButton;

    KABC::AddressBook *mAddressBook;
};

#endif
