/*
    This file is part of KAddressbook.

    Copyright (c) 2004 Tobias Koenig <tokoe@kde.org>
    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef ADVANCEDCUSTOMFIELDS_H
#define ADVANCEDCUSTOMFIELDS_H

#include <klocale.h>

#include <tqmap.h>
#include <tqpair.h>
#include <tqstringlist.h>

#include <libkdepim/designerfields.h>

#include "contacteditorwidget.h"

class AdvancedCustomFields : public KAB::ContactEditorWidget
{
  Q_OBJECT
  TQ_OBJECT

  public:
    AdvancedCustomFields( const TQString &uiFile, KABC::AddressBook *ab,
                          TQWidget *parent, const char *name = 0 );

    void loadContact( KABC::Addressee *addr );
    void storeContact( KABC::Addressee *addr );
    void setReadOnly( bool readOnly );

    TQString pageIdentifier() const;
    TQString pageTitle() const;

  private:
    void initGUI( const TQString& );

    KPIM::DesignerFields *mFields;
};

#endif
