/*
    qgpgmekeylistjob.h

    This file is part of libkleopatra, the KDE keymanagement library
    Copyright (c) 2004 Klarlvdalens Datakonsult AB

    Libkleopatra is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.

    Libkleopatra is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

    In addition, as a special exception, the copyright holders give
    permission to link the code of this program with any edition of
    the TQt library by Trolltech AS, Norway (or with modified versions
    of TQt that use the same license as TQt), and distribute linked
    combinations including the two.  You must obey the GNU General
    Public License in all respects for all of the code used other than
    TQt.  If you modify this file, you may extend this exception to
    your version of the file, but you are not obligated to do so.  If
    you do not wish to do so, delete this exception statement from
    your version.
*/

#ifndef __KLEO_TQGPGMEKEYLISTJOB_H__
#define __KLEO_TQGPGMEKEYLISTJOB_H__

#include <kleo/keylistjob.h>

#include <gpgmepp/keylistresult.h>

#include "qgpgmejob.h"

namespace GpgME {
  class Error;
  class Context;
  class Key;
}

namespace Kleo {

  class QGpgMEKeyListJob : public KeyListJob, private QGpgMEJob {
    Q_OBJECT
    TQ_OBJECT TQGPGME_JOB
  public:
    QGpgMEKeyListJob( GpgME::Context * context );
    ~QGpgMEKeyListJob();

    /*! \reimp from KeyListJob */
    GpgME::Error start( const TQStringList & patterns, bool secretOnly );

    /*! \reimp from KeyListJob */
    GpgME::KeyListResult exec( const TQStringList & patterns, bool secretOnly, std::vector<GpgME::Key> & keys );

    /*! \reimp from Job */
    void showErrorDialog( TQWidget * parent, const TQString & caption ) const;

  private slots:
    void slotNextKeyEvent( GpgME::Context * context, const GpgME::Key & key );
    void slotOperationDoneEvent( GpgME::Context * context, const GpgME::Error & e );
    void slotFakeOperationDoneEvent();

  private:
    void doOperationDoneEvent( const GpgME::Error &) {} // unused, we implement slotOperationDoneEvent ourselves.
    void setup( const TQStringList &, bool );
    GpgME::KeyListResult attemptSyncKeyListing( std::vector<GpgME::Key> & );

  private:
    GpgME::KeyListResult mResult;
    bool mSecretOnly;
  };

}

#endif // __KLEO_TQGPGMEKEYLISTJOB_H__
