/*
    This file is part of Akregator.

    Copyright (C) 2004 Stanislav Karchebny <Stanislav.Karchebny@kdemail.net>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#ifndef AKREGATORTRAYICON_H
#define AKREGATORTRAYICON_H

#include <ksystemtray.h>

#include <tqimage.h>
#include <tqpixmap.h>

namespace Akregator
{
    class TrayIcon : public KSystemTray
    {
        Q_OBJECT
  TQ_OBJECT
        public:
            static TrayIcon* getInstance();
            static void setInstance(TrayIcon* trayIcon);
            
            TrayIcon(TQWidget *parent = 0, const char *name = 0);
            ~TrayIcon();
            
            TQPixmap takeScreenshot() const;
            virtual void mousePressEvent(TQMouseEvent *);
        public slots:
            void settingsChanged();
            void slotSetUnread(int unread);
            void viewButtonClicked();
        
        signals:
            void showPart();

        private:
            static TrayIcon* m_instance;
            
            TQPixmap m_defaultIcon;
            TQImage m_lightIconImage;
            int m_unread;
    };
}

#endif
