#ifndef BGHASH_H
#define BGHASH_H

/*
 * TQString -> int hash. From Qt's TQGDict::hashKeyString().
 */

static int TQHash(TQString key)
{
    int g, h = 0;
    const TQChar *p = key.tqunicode();
    for (unsigned i=0; i < key.length(); i++) {
        h = (h << 4) + p[i].cell();
        if ((g = (h & 0xf0000000)))
            h ^= (g >> 24);
        h &= ~g;
    }
    return h;
}

#endif

