/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2003-2006                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

#include "pkgcontentspage.h"
#include <tqlayout.h>
#include <klocale.h>
#include "../umlobjectlist.h"
#include "../uml.h"
#include "../umldoc.h"
#include "classpropdlg.h"

PkgContentsPage::PkgContentsPage(TQWidget *parent, UMLPackage *pkg)
        : TQWidget(parent)
{
    m_pPackage = pkg;
    int margin = fontMetrics().height();

    TQHBoxLayout * mainLayout = new TQHBoxLayout(this);
    mainLayout -> setSpacing(10);

    m_pContentGB = new TQGroupBox(i18n("Contained Items"), this);
    mainLayout -> addWidget(m_pContentGB);

    TQHBoxLayout * tqlayout = new TQHBoxLayout(m_pContentGB);
    tqlayout -> setSpacing(10);
    tqlayout -> setMargin(margin);

    m_pContentLB = new TQListBox(m_pContentGB);
    tqlayout -> addWidget(m_pContentLB);
    setMinimumSize(310, 330);
    fillListBox();
    m_pMenu = 0;

    connect(m_pContentLB, TQT_SIGNAL(doubleClicked(TQListBoxItem *)),
            this, TQT_SLOT(slotDoubleClick(TQListBoxItem *)));

    connect(m_pContentLB, TQT_SIGNAL(rightButtonPressed(TQListBoxItem *, const TQPoint &)),
            this, TQT_SLOT(slotRightButtonPressed(TQListBoxItem *, const TQPoint &)));

    connect(m_pContentLB, TQT_SIGNAL(rightButtonClicked(TQListBoxItem *, const TQPoint &)),
            this, TQT_SLOT(slotRightButtonClicked(TQListBoxItem *, const TQPoint &)));
}

PkgContentsPage::~PkgContentsPage() {
    disconnect(m_pContentLB, TQT_SIGNAL(doubleClicked(TQListBoxItem *)),
               this, TQT_SLOT(slotDoubleClick(TQListBoxItem *)));

    disconnect(m_pContentLB, TQT_SIGNAL(rightButtonPressed(TQListBoxItem *, const TQPoint &)),
               this, TQT_SLOT(slotRightButtonPressed(TQListBoxItem *, const TQPoint &)));

    disconnect(m_pContentLB, TQT_SIGNAL(rightButtonClicked(TQListBoxItem *, const TQPoint &)),
               this, TQT_SLOT(slotRightButtonClicked(TQListBoxItem *, const TQPoint &)));
}

void PkgContentsPage::slotDoubleClick(TQListBoxItem * i) {
    if (!i)
        return;
    int item = m_pContentLB -> currentItem();
    UMLObjectList contents = m_pPackage->containedObjects();
    UMLObject *o = contents.at(item);
    ClassPropDlg dlg(this, o, item, true);
    dlg.exec();
}

void PkgContentsPage::fillListBox() {
    m_pContentLB->clear();
    UMLObjectList contents = m_pPackage->containedObjects();
    UMLObjectListIt objList_it(contents);
    UMLObject* umlo = NULL;
    int i = 0;
    while ((umlo = objList_it.current()) != NULL) {
        m_pContentLB->insertItem(umlo->getName(), i++);
        ++objList_it;
    }
}

void PkgContentsPage::slotRightButtonClicked(TQListBoxItem */* item*/, const TQPoint &/* p*/) {
    if(m_pMenu) {
        m_pMenu -> hide();
        disconnect(m_pMenu, TQT_SIGNAL(activated(int)), this, TQT_SLOT(slotPopupMenuSel(int)));
        delete m_pMenu;
        m_pMenu = 0;
    }
}

void PkgContentsPage::slotRightButtonPressed(TQListBoxItem * item, const TQPoint & p) {
    if(!item)
        return;
    if(m_pMenu) {
        m_pMenu -> hide();
        disconnect(m_pMenu, TQT_SIGNAL(activated(int)), this, TQT_SLOT(slotPopupMenuSel(int)));
        delete m_pMenu;
        m_pMenu = 0;
    }
    m_pMenu = new ListPopupMenu(this, ListPopupMenu::mt_Association_Selected);
    m_pMenu->popup(p);
    connect(m_pMenu, TQT_SIGNAL(activated(int)), this, TQT_SLOT(slotPopupMenuSel(int)));
}

void PkgContentsPage::slotPopupMenuSel(int id) {
    switch(id) {
    case ListPopupMenu::mt_Delete:
        {
            UMLObjectList contents = m_pPackage->containedObjects();
            UMLObject *o = contents.at( m_pContentLB->currentItem() );
            UMLApp::app()->getDocument()->removeUMLObject(o);
            fillListBox();
        }
        break;

    case ListPopupMenu::mt_Properties:
        slotDoubleClick(m_pContentLB->item(m_pContentLB->currentItem()));
        break;
    }
}



#include "pkgcontentspage.moc"
