/*
 * $Id: scheck.h 1246075 2011-08-10 06:08:18Z tpearson $
 *
 * KDE3 Style Guide compliance check "Style", v0.0.1
 *        Copyright (C) 2002 Maksim Orlovich <orlovich@cs.rochester.edu>
 *                         (C) 2002 Ryan Cumming <bodnar42@phalynx.dhs.org>
 *
 *
 * Based on the KDE3 HighColor Style (version 1.0):
 *      Copyright (C) 2001-2002 Karol Szwed      <gallium@kde.org>
 *                 (C) 2001-2002 Fredrik Hglund  <fredrik@kde.org>
 *
 *       Drawing routines adapted from the KDE2 HCStyle,
 *       Copyright (C) 2000 Daniel M. Duley       <mosfet@kde.org>
 *                 (C) 2000 Dirk Mueller          <mueller@kde.org>
 *                 (C) 2001 Martijn Klingens      <klingens@kde.org>
 *
 *  Portions of code are from the TQt GUI Toolkit,  Copyright (C) 1992-2000 Trolltech AS.
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; see the file COPYING.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 *
 *
 */

#ifndef STYLE_CHECK_H
#define STYLE_CHECK_H

#include <tqbitmap.h>
#include <tqheader.h>
#include <tqintdict.h>
#include <tqvaluevector.h>
#include <tqguardedptr.h>

#include <kdrawutil.h>
#include <kpixmap.h>
#include <kstyle.h>


class TQPopupMenu;

class StyleCheckTitleWatcher: public TQObject
{
	Q_OBJECT
  TQ_OBJECT

	public:
		StyleCheckTitleWatcher();
		void addWatched(TQWidget* w);
	public slots:
		void slotCheck();
	private:
		TQString cleanErrorMarkers(TQString in);
		TQValueVector<TQGuardedPtr<TQWidget> > watched;
		TQValueVector<TQString> watchedTitles;
};

class StyleCheckStyle : public KStyle
{
	Q_OBJECT
  TQ_OBJECT

	public:
		StyleCheckStyle( );
		virtual ~StyleCheckStyle();

		void polish( TQWidget* widget );
		void unPolish( TQWidget* widget );


		void drawKStylePrimitive( KStylePrimitive kpe,
					TQPainter* p,
					const TQWidget* widget,
					const TQRect &r,
					const TQColorGroup &cg,
					SFlags flags = Style_Default,
					const TQStyleOption& = TQStyleOption::Default ) const;

		void drawPrimitive( PrimitiveElement pe,
					TQPainter* p,
					const TQRect &r,
					const TQColorGroup &cg,
					SFlags flags = Style_Default,
					const TQStyleOption& = TQStyleOption::Default ) const;

		void tqdrawControl( ControlElement element,
					TQPainter *p,
					const TQWidget *widget,
					const TQRect &r,
					const TQColorGroup &cg,
					SFlags flags = Style_Default,
					const TQStyleOption& = TQStyleOption::Default ) const;

		void tqdrawControlMask( ControlElement element,
					TQPainter *p,
					const TQWidget *widget,
					const TQRect &r,
					const TQStyleOption& = TQStyleOption::Default ) const;

		void tqdrawComplexControl( ComplexControl control,
					TQPainter *p,
					const TQWidget *widget,
					const TQRect &r,
					const TQColorGroup &cg,
					SFlags flags = Style_Default,
					SCFlags controls = SC_All,
					SCFlags active = SC_None,
					const TQStyleOption& = TQStyleOption::Default ) const;

		void tqdrawComplexControlMask( ComplexControl control,
					TQPainter *p,
					const TQWidget *widget,
					const TQRect &r,
					const TQStyleOption& = TQStyleOption::Default ) const;

		int tqpixelMetric( PixelMetric m,
					const TQWidget *widget = 0 ) const;

		TQSize sizeFromContents( ContentsType contents,
					const TQWidget *widget,
					const TQSize &contentSize,
					const TQStyleOption& opt ) const;

		TQRect subRect( SubRect r,
					const TQWidget *widget ) const;

		// Fix TQt3's wacky image positions
		TQPixmap stylePixmap( StylePixmap stylepixmap,
					const TQWidget *widget = 0,
					const TQStyleOption& = TQStyleOption::Default ) const;

	protected:
		bool eventFilter( TQObject *object, TQEvent *event );

		void renderGradient( TQPainter* p,
					const TQRect& r,
					TQColor clr,
					bool horizontal,
					int px=0,
					int py=0,
					int pwidth=-1,
					int pheight=-1 ) const;

		TQTimer     *topLevelAccelManageTimer;
		TQWidget    *hoverWidget;

	private slots:
		void slotAccelManage();
		
	private:
		void accelManageRecursive(TQWidget* widget);
            
		StyleCheckTitleWatcher* watcher;

		// Disable copy constructor and = operator
		StyleCheckStyle( const StyleCheckStyle & );
		StyleCheckStyle& operator=( const StyleCheckStyle & );
};

// vim: set noet ts=4 sw=4:
// kate: indent-width 4; replace-tabs off; tab-width 4; space-indent off;

#endif
