/***************************************************************************
                                diffhunk.cpp  -  description
                                -------------------
        begin                   : Sun Mar 4 2001
        copyright               : (C) 2001-2003 by Otto Bruggeman
                                  and John Firebaugh
        email                   : otto.bruggeman@home.nl
                                  jfirebaugh@kde.org
****************************************************************************/

/***************************************************************************
**
**   This program is free software; you can redistribute it and/or modify
**   it under the terms of the GNU General Public License as published by
**   the Free Software Foundation; either version 2 of the License, or
**   (at your option) any later version.
**
***************************************************************************/


#include "difference.h"
#include "diffhunk.h"

using namespace Diff2;

DiffHunk::DiffHunk( int sourceLine, int destinationLine, TQString function, Type type ) :
	m_sourceLine( sourceLine ),
	m_destinationLine( destinationLine ),
	m_function( function ),
	m_type( type )
{
}

DiffHunk::~DiffHunk()
{
}

void DiffHunk::add( Difference* diff )
{
	m_differences.append( diff );
}

int DiffHunk::sourceLineCount() const
{
	DifferenceListConstIterator diffIt = m_differences.begin();
	DifferenceListConstIterator dEnd   = m_differences.end();

	int lineCount = 0;

	for ( ; diffIt != dEnd; ++diffIt )
		lineCount += (*diffIt)->sourceLineCount();

	return lineCount;
}

int DiffHunk::destinationLineCount() const
{
	DifferenceListConstIterator diffIt = m_differences.begin();
	DifferenceListConstIterator dEnd   = m_differences.end();

	int lineCount = 0;

	for ( ; diffIt != dEnd; ++diffIt )
		lineCount += (*diffIt)->destinationLineCount();

	return lineCount;
}

TQString DiffHunk::recreateHunk() const
{
	TQString hunk;
	TQString differences;

	// recreate body
	DifferenceListConstIterator diffIt = m_differences.begin();
	DifferenceListConstIterator dEnd   = m_differences.end();

	int slc = 0; // source line count
	int dlc = 0; // destination line count
	for ( ; diffIt != dEnd; ++diffIt )
	{
		switch ( (*diffIt)->type() )
		{
		case Difference::Unchanged:
		case Difference::Change:
			slc += (*diffIt)->sourceLineCount();
			dlc += (*diffIt)->destinationLineCount();
			break;
		case Difference::Insert:
			dlc += (*diffIt)->destinationLineCount();
			break;
		case Difference::Delete:
			slc += (*diffIt)->sourceLineCount();
			break;
		}
		differences += (*diffIt)->recreateDifference();
	}

	// recreate header
	hunk += TQString::tqfromLatin1( "@@ -%1,%3 +%2,%4 @@" )
	        .tqarg( m_sourceLine )
	        .tqarg( m_destinationLine )
	        .tqarg( slc )
	        .tqarg( dlc ); 

	if ( !m_function.isEmpty() )
		hunk += " " + m_function;

	hunk += TQString::tqfromLatin1( "\n" );

	hunk += differences;

	kdDebug( 8101 ) << hunk << endl;
	return hunk;
}
